/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  ne2000hdl.h
 * @brief %jp{NE2000ߴEtherѥϡɥ}
 *
 * Copyright (C) 2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef __HOS__ne2000hal_h__
#define __HOS__ne2000hal_h__


/* NE2000ߴNICɥ饤Х饹 */
typedef struct c_ne2000file
{
	volatile unsigned char *pubRegBase;			/* 쥸Υ١ɥ쥹 */
	unsigned char          ubPhysicalAddr[6];	/* ʪɥ쥹 */
} C_NE2000HAL;

#ifdef __cplusplus
extern "C" {
#endif

void    Ne2000Hal_Create(C_NE2000HAL *self, void *pRegAddr);							/**< %jp{󥹥ȥ饯} */
void    Ne2000Hal_Delete(C_NE2000HAL *self);											/**< %jp{ǥȥ饯} */
void    Ne2000Hal_Setup(C_NE2000HAL *self);												/**< %jp{} */
void    Ne2000Hal_Stop(C_NE2000HAL *self);												/**< %jp{} */
int     Ne2000Hal_Recv(C_NE2000HAL *self, void *pRecvBuf, int iSize);					/**< %jp{ѥåȼ} */
int     Ne2000Hal_Send(C_NE2000HAL *self, const void *pData, int iSize);				/**< %jp{ѥå} */
#define Ne2000Hal_GetPhysicalAddr(self)	((const unsigned char *)(self->ubPhysicalAddr))	/**< %jp{ʪɥ쥹} */

#ifdef __cplusplus
}
#endif


#endif	/* __HOS__ne2000hal_h__ */


/* end of file */
