/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  memdrv.h
 * @brief %jp{ޥåץɥեѥǥХɥ饤}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include <string.h>
#include "memdrv_local.h"
#include "memfile_local.h"


FILE_SIZE MemDrv_Write(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj, const void *pData, FILE_SIZE Size)
{
	C_MEMDRV	*self;
	C_MEMFILE	*pFile;
	
	/* upper cast */
	self  = (C_MEMDRV *)pDrvObj;
	pFile = (C_MEMFILE *)pFileObj;

	
	SysMtx_Lock(self->hMtx);
	
	/* å */
	if ( Size > self->MemSize - pFile->FilePos )
	{
		Size = self->MemSize - pFile->FilePos;
	}
	
	/*  */
	memcpy(self->pubMemAddr + pFile->FilePos, pData, Size);
	pFile->FilePos += Size;
	
	/* ե륵ĥ */
	if ( self->FileSize < pFile->FilePos )
	{
		self->FileSize = pFile->FilePos;
	}
	
	SysMtx_Unlock(self->hMtx);
	
	return Size;
}


/* end of file */
