/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  streampipe.c
 * @brief %jp{ȥ꡼ѥ}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "streampipe_local.h"


/** 󥹥ȥ饯 */
FILE_ERR StreamPipe_Constructor(C_STREAMPIPE *self, const T_DRVOBJ_METHODS *pMethods, int iBufSize)
{
	FILE_ERR	ErrCode;
	void 		*pMem;

	/* Хåե */
	if ( (pMem = SysMem_Alloc(iBufSize)) == NULL )
	{
		return FILE_ERR_NG;
	}
	
	/* ƥ饹󥹥ȥ饯ƤӽФ */
	if ( (ErrCode = SyncDrv_Constructor(&self->SyncDrv, pMethods, SYNCDRV_FACTOR_NUM)) != FILE_ERR_OK )
	{
		SysMem_Free(pMem);
		return ErrCode;
	}

	/* ѿ */
	self->iOpenCount = 0;
	
	/* Хåե */
	StreamBuf_Create(&self->StreamBuf, iBufSize, pMem);
	
	return FILE_ERR_OK;
}


/* end of file */
