/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  mn103scdrv_write.c
 * @brief %jp{MN103꡼ ꥢ륤󥿡եѥǥХɥ饤}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "mn103scdrv_local.h"


/** %jp{} */
FILE_SIZE Mn103ScDrv_Write(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj, const void *pData, FILE_SIZE Size)
{
	C_MN103SCDRV		*self;
	C_SYNCFILE			*pFile;
	const unsigned char	*pubBuf;
	FILE_ERR			ErrCode;
	FILE_SIZE			i;
	int					c;
	
	/* upper cast */
	self  = (C_MN103SCDRV *)pDrvObj;
	pFile = (C_SYNCFILE *)pFileObj;
	
	pubBuf = (const unsigned char *)pData;
	
	/* ߽ */
	if ( (ErrCode = SyncDrv_StartProcess(&self->SyncDrv, pFile, SYNCDRV_FACTOR_WRITE)) != FILE_ERR_OK )
	{
		return (FILE_SIZE)ErrCode;
	}

	/* ߥʥöꥢ */
	SyncFile_ClearSignal(pFile, SYNCDRV_FACTOR_WRITE);
	
	for ( i = 0; i < Size; i++ )
	{
		/* ʸФ */
		c = *pubBuf++;
		
		/* ǽå */
		while ( (MN103SC_READ_STR(self) & 0x80 ) )
		{
			/* ߵ */
			SysInt_Enable(self->iIntNumTx);
			
			/* ֥å󥰥⡼ɤǤʤȴ */
			if ( SyncFile_GetSyncMode(pFile, SYNCDRV_FACTOR_WRITE) != FILE_SYNCMODE_BLOCKING )
			{
				SyncDrv_EndProcess(&self->SyncDrv, SYNCDRV_FACTOR_WRITE, i);
				return i;
			}
			
			/* ߥʥԤ */
			SyncFile_WaitSignal(pFile, SYNCDRV_FACTOR_WRITE);
			
			/* ߥʥ򥯥ꥢƥȥ饤 */
			SyncFile_ClearSignal(pFile, SYNCDRV_FACTOR_WRITE);
		}
		
		/*  */
		MN103SC_WRITE_TB(self, (unsigned char)c);
	}
	
	/* ߽λ */
	SyncDrv_EndProcess(&self->SyncDrv, SYNCDRV_FACTOR_WRITE, (VPARAM)i);
	
	return i;
}


/* end of file */
