/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  scidrv.c
 * @brief %jp{PC16550ѥǥХɥ饤}
 *
 * Copyright (C) 2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "pc16550drv_local.h"


/* ߥӥ롼 */
void Pc16550Drv_Isr(VPARAM Param)
{
	C_PC16550DRV	*self;
	int				iIntStatus;
	int				c;

	self = (C_PC16550DRV *)Param;

	/* ߾֤μ */
	iIntStatus = Pc16550Hal_GetInterruptStatus(&self->Pc16550Hal);
	switch ( iIntStatus )
	{
	case PC16550HAL_IIR_RDA:
	case PC16550HAL_IIR_CTI:
		/* ʸɤ߽ФΤISRǹԤ */
		while ( (c = Pc16550Hal_RecvChar(&self->Pc16550Hal)) >= 0 )
		{
			StreamBuf_SendChar(&self->StmBufRecv, c);
		}
		
		/* ɹߥʥȯ */
		SyncDrv_SendSignal(&self->SyncDrv, SYNCDRV_FACTOR_READ);
		break;

	case PC16550HAL_IIR_THRE:
		/*  */
		Pc16550Hal_EnableInterrupt(&self->Pc16550Hal, PC16550HAL_IER_ERBFI);
		
		/* ߥʥȯ */
		SyncDrv_SendSignal(&self->SyncDrv, SYNCDRV_FACTOR_WRITE);
	}
	
	SysInt_Clear(self->iIntNum);
}


/* end of file */
