/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  scidrv.c
 * @brief %jp{Renesas H8/SH SCIǥХɥ饤}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "scidrv_local.h"


/**  */
void SciDrv_Close(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj)
{
	C_SCIDRV	*self;
	
	/* upper cast */
	self = (C_SCIDRV *)pDrvObj;

	/*  */
	if ( --self->iOpenCount == 0 )
	{
		SciHal_EnableInterrupt(&self->SciHal, 0);
		SciHal_Stop(&self->SciHal);
		StreamBuf_Clear(&self->StmBufRecv);
	}
	
	/* ǥץ */
	SysMem_Free(pFileObj);
}


/* end of file */
