/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  scidrv.c
 * @brief %jp{SCIѥǥХɥ饤}
 *
 * Copyright (C) 2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "scidrv_local.h"



/* 顼 */
void SciDrv_IsrRecvErr(VPARAM Param)
{
	SciDrv_IsrRecv(Param);
}


/*  */
void SciDrv_IsrRecv(VPARAM Param)
{
	C_SCIDRV *self;
	int c;
	
	self = (C_SCIDRV *)Param;
	
	while ( (c = SciHal_RecvChar(&self->SciHal)) >= 0 )
	{
		StreamBuf_SendChar(&self->StmBufRecv, c);
	}
	SysEvt_Set(self->hEvtRecv);
}


/* ץƥ */
void SciDrv_IsrSend(VPARAM Param)
{
	C_SCIDRV *self;
	
	self = (C_SCIDRV *)Param;
	
	SciHal_EnableInterrupt(&self->SciHal, SCIHAL_INT_RIE);
	SysEvt_Set(self->hEvtSend);
}


/* λ */
void SciDrv_IsrSendEnd(VPARAM Param)
{
	C_SCIDRV *self;

	self = (C_SCIDRV *)Param;
	
	SysEvt_Set(self->hEvtSend);
}


/* end of file */
