/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  scihdl.h
 * @brief %jp{SCIѥϡɥ}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef __HOS__renesas__scihal_h__
#define __HOS__renesas__scihal_h__


#define SCIHAL_INT_TIE		0x80				/* ߵ */
#define SCIHAL_INT_RIE		0x40				/* ߵ */
#define SCIHAL_INT_TEIE		0x04				/* ߵ */


/* SCIѥϡɥ */
typedef struct c_scihal
{
	volatile unsigned char	*pRegBase;			/* 쥸Υ١ɥ쥹 */
	unsigned long			ulSysClock;			/* ƥ९åȿ */
} C_SCIHAL;


#ifdef __cplusplus
extern "C" {
#endif

/* SCIѥϡɥ */
void SciHal_Create(C_SCIHAL *self, void *pRegAddr, unsigned long ulSysClock);	/**< 󥹥ȥ饯 */
void SciHal_Delete(C_SCIHAL *self);												/**< ǥȥ饯 */
void SciHal_Setup(C_SCIHAL *self);												/**< %jp{SCIν} */
void SciHal_SetSpeed(C_SCIHAL *self, unsigned long ulSpeed);					/**< %jp{SCI®} */
void SciHal_Stop(C_SCIHAL *self);												/**< %jp{SCI} */
int  SciHal_SendChar(C_SCIHAL *self, int c);									/**< %jp{1ʸ} */
int  SciHal_RecvChar(C_SCIHAL *self);											/**< %jp{1ʸ} */
void SciHal_EnableInterrupt(C_SCIHAL *self, unsigned char flag);				/**< %jp{ߵ} */

#ifdef __cplusplus
}
#endif


#endif	/* __HOS__renesas__scihal_h__ */


/* end of file */
