/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  ipether.h
 * @brief %jp{EtherIPץȥ(ĤޤMACض)}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef __HOS__ipether_h__
#define __HOS__ipether_h__


#include "system/sysapi/sysapi.h"
#include "system/file/syncdrv_local.h"


#define IPETHER_ARPTBL_SIZE			4
#define IPETHER_RECVBUS_SIZE		4
#define IPETHER_MAXPACKET_SIZE		2048


/* IP-Ether */
typedef struct t_ipether_inf
{
	unsigned char	ubIpAddr[4];			/* IPɥ쥹 */
	unsigned char	ubSubNetMask[4];		/* ֥ͥåȥޥ */
	unsigned char	ubGateWayIpAddr[4];		/* ǥեȥȥɥ쥹 */
} T_IPETHER_INF;



/* ARPơ֥ */
typedef struct t_ipether_arptbl
{
	unsigned char	ubIpAddr[4];	/* IPɥ쥹 */
	unsigned char	ubMacAddr[6];	/* MACɥ쥹 */
} T_IPETHER_ARPTBL;



/* Etherɥ饤 */
typedef struct c_ipether
{
	C_SYNCDRV			SyncDrv;				/* 饯ǥХɥ饤ФѾ */

	HANDLE				hEther;					/* Etherɥ饤 */
	
	int					iOpenCount;				/* ץ󥫥 */

	SYSPRC_HANDLE		hPrcRecv;				/* ץ */
	SYSMTX_HANDLE		hMtxSend;				/* ¾ߥ塼ƥå */
	SYSMTX_HANDLE		hMtxRecv;				/* ¾ߥ塼ƥå */
	SYSMTX_HANDLE		hMtxArp;				/* ¾ߥ塼ƥå */

	SYSEVT_HANDLE		hEvtRecv;				/*  */
	SYSEVT_HANDLE		hEvtArp;				/*  */

	unsigned char		ubMyIpAddr[4];			/* IPɥ쥹 */
	unsigned char		ubMyMacAddr[6];			/* MACɥ쥹 */
	
	unsigned char		ubSubNetMask[4];		/* ֥ͥåȥޥ */
	unsigned char		ubGateWayIpAddr[4];		/* ȥIPɥ쥹 */
	
	T_IPETHER_ARPTBL	ArpTbl[IPETHER_ARPTBL_SIZE];
	
	int					iRecvHead;				/* ѥåƬ */
	int					iRecvNum;				/* ѥåȿ */

	unsigned char		ubSendBuf[IPETHER_MAXPACKET_SIZE];
	unsigned char		ubRecvBuf[IPETHER_RECVBUS_SIZE][IPETHER_MAXPACKET_SIZE];
} C_IPETHER;


#ifdef __cplusplus
extern "C" {
#endif

HANDLE IpEther_Create(const char *pszEther, const T_IPETHER_INF *pInf);		/**<  */
void   IpEther_Delete(HANDLE hDriver);										/**<  */

#ifdef __cplusplus
}
#endif


#endif	/* __HOS__ipether_h__ */



/* endof file */
