/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  ipether.h
 * @brief %jp{EtherIPץȥ(ĤޤMACض)}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include <string.h>
#include "ipether_local.h"


/* ۴ؿơ֥ */
static const T_DRVOBJ_METHODS IpEther_Methods = 
	{
		IpEther_Delete,
		IpEther_Open,
		IpEther_Close,
		IpEther_IoControl,
		IpEther_Seek,
		IpEther_Read,
		IpEther_Write,
		IpEther_Flush,
	};


/**<  */
HANDLE IpEther_Create(const char *pszEther, const T_IPETHER_INF *pInf)
{
	C_IPETHER *self;
	
	/*  */
	if ( (self = (C_IPETHER *)SysMem_Alloc(sizeof(C_IPETHER))) == NULL )
	{
		return HANDLE_NULL;
	}
	
	/* 󥹥ȥ饯ƤӽФ */
	if ( IpEther_Constructor(self, &IpEther_Methods, pszEther, pInf) != FILE_ERR_OK )
	{
		SysMem_Free(self);
		return HANDLE_NULL;
	}
	
	return (HANDLE)self;
}


/* endof file */
