/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  fatvol.c
 * @brief %jp{FATܥ塼ѥǥХɥ饤}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "fatvol_local.h"


/** 饹ɤ߹ */
int FatVol_ClusterRead(
		C_FATVOL    *self,
		FATVOL_UINT uiCluster,
		void        *pBuf)
{
	FATVOL_UINT uiPos;
	FILE_SIZE	uiSize;

	if ( uiCluster >= 0x0f000000 && (self->iFatType == FATVOL_TYPE_FAT12 || self->iFatType == FATVOL_TYPE_FAT16) )
	{
		/* FAT12/16 Υ롼ȥǥ쥯ȥ 0xf0000000 ˥ޥå */
		uiCluster -= 0x0f000000;
		
		/* ɤ߽Фְư */
		uiPos = (self->RootDirSector + (uiCluster * self->SectorsPerCluster)) * self->BytesPerSector + self->Offset;
		if ( File_Seek(self->hBlockFile, uiPos, FILE_SEEK_SET) != uiPos )
		{
			return FATVOL_ERR_NG;
		}
		
		/* ɤ߽Ф */
		uiSize = (FILE_SIZE)self->BytesPerCluster;
		if ( File_Read(self->hBlockFile, pBuf, uiSize) != uiSize )
		{
			return FATVOL_ERR_NG;
		}
	}
	else
	{
		/* ɤ߽Фְư */
		uiPos = (self->Cluster0Sector + (uiCluster * self->SectorsPerCluster)) * self->BytesPerSector + self->Offset;
		if ( File_Seek(self->hBlockFile, uiPos, FILE_SEEK_SET) != uiPos )
		{
			return FATVOL_ERR_NG;
		}

		/* ɤ߽Ф */
		uiSize = (FILE_SIZE)self->BytesPerCluster;
		if ( File_Read(self->hBlockFile, pBuf, uiSize) != uiSize )
		{
			return FATVOL_ERR_NG;
		}
	}
	
	return FATVOL_ERR_OK;
}


/* end of file */
