/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  fatvol.c
 * @brief %jp{FATܥ塼ѥǥХɥ饤}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include <string.h>
#include "fatvol_local.h"


static int FatVol_AlloctClusterBuf(C_FATVOL *self, FATVOL_UINT uiCluster, int iRead);


T_FATVOL_CLUSTERBUF *FatVol_GetClusterBuf(C_FATVOL *self, FATVOL_UINT uiCluster, int iRead)
{
	int iIndex;
	
	/* ХåեƤ */
	iIndex = FatVol_AlloctClusterBuf(self, uiCluster, iRead);
	if ( iIndex < 0 )
	{
		return NULL;
	}
	
	/* ¤ؤ */
	if ( iIndex != 0 )
	{
		T_FATVOL_CLUSTERBUF Tmp;
		Tmp = self->pClusterBuf[iIndex];
		memmove(&self->pClusterBuf[1], &self->pClusterBuf[0], iIndex * sizeof(T_FATVOL_CLUSTERBUF));
		self->pClusterBuf[0] = Tmp;
	}

	return 	&self->pClusterBuf[0];
}


int FatVol_AlloctClusterBuf(C_FATVOL *self, FATVOL_UINT uiCluster, int iRead)
{
	int iIndex;
	
	if ( uiCluster < 2 || uiCluster >= 0x0ffffff7 )
	{
		return -1;
	}
	
	/* ˥Хåե˵ʤõ */
	for ( iIndex = 0; iIndex < self->iClusterBufNum; iIndex++ )
	{
		/* Ĥд¸Хåե֤ */
		if ( self->pClusterBuf[iIndex].uiClusterNum == uiCluster )
		{
			return iIndex;
		}
	}
	
	
	/* ΥХåեõ */
	for ( iIndex = 0; iIndex < self->iClusterBufNum; iIndex++ )
	{
		if ( self->pClusterBuf[iIndex].uiClusterNum == FATVOL_CLUSTER_ENDMARKER )
		{
			break;
		}
	}
	
	/* ̵ж */
	if ( iIndex >= self->iClusterBufNum )
	{
		/*  */
		iIndex = self->iClusterBufNum - 1;

		/* dirtyʤǤФ */
		if ( self->pClusterBuf[iIndex].iDirty )
		{
			if ( FatVol_ClusterWrite(self, self->pClusterBuf[iIndex].uiClusterNum, self->pClusterBuf[iIndex].pubBuf) != FATVOL_ERR_OK )
			{
				return -1;
			}
			self->pClusterBuf[iIndex].iDirty = 0;
		}
		self->pClusterBuf[iIndex].uiClusterNum = FATVOL_CLUSTER_ENDMARKER;
	}
	
	/* Хåեɤ߹ */
	if ( iRead )
	{
		if ( FatVol_ClusterRead(self, uiCluster, self->pClusterBuf[iIndex].pubBuf) != FATVOL_ERR_OK )
		{
			return -1;
		}
	}
	self->pClusterBuf[iIndex].iDirty       = 0;
	self->pClusterBuf[iIndex].uiClusterNum = uiCluster;
	
	return iIndex;	
}


/* end of file */
