/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  fatvol.c
 * @brief %jp{FATܥ塼ѥǥХɥ饤}
 *
 * Copyright (C) 2006-2009 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include <string.h>
#include "hosaplfw.h"
#include "fatvol_local.h"


/* ե륪ץ */
HANDLE FatVol_Open(C_DRVOBJ *pDrvObj, const char *pszPath, int iMode)
{
	C_FATVOL 			*self;
	HANDLE 				hFile;
	FATVOL_UINT			uiDirStartCluster;	
	FATVOL_UINT			uiDirCluster;	
	FATVOL_UINT			uiDirEntryPos;
	char   				szName[8+3];
	int    				iNameLen;
	FATVOL_UINT			uiFileCluster;
	unsigned char		ubFileAttr;
	FILE_POS			FileSize;
	T_FATVOL_CLUSTERBUF *pClusterBuf;
	unsigned char		*pubBuf;
	int					iEntryHit;
	int    				i, j;
	
	
	/* upper cast */
	self = (C_FATVOL *)pDrvObj;
	
	
	/* ƥ륻 */
	SysMtx_Lock(self->hMtx);
	
	
	/* 롼ȥǥ쥯ȥ */
	uiDirStartCluster = FATVOL_CLUSTER_ENDMARKER;
	uiDirCluster      = FATVOL_CLUSTER_ENDMARKER;
	uiDirEntryPos     = 0;
	uiFileCluster     = self->RootDirCluster;
	ubFileAttr        = 0x10;
	FileSize          = 0;
	
	/* ѥõ */
	for ( ; ; )
	{
		/* ڤɤФ */
		while ( pszPath[0] == '/' )
		{
			pszPath++;
		}

		/* ̾ʬõ */
		for ( i = 0; pszPath[i] != '\0'; i++ )
		{
			/* ѥڤʤȴ */
			if ( pszPath[i] == '/' )
			{
				break;
			}
		}
		iNameLen = i;

		/* ǥ쥯ȥ꼫Ȥؤ */
		if ( iNameLen == 0 )
		{
			iEntryHit = 1;
			break;
		}
		
		/* ǥ쥯ȥꥨȥ̾ */
		for ( i = 0, j = 0; i < iNameLen && j < 8; i++, j++ )
		{
			if ( pszPath[i] == '.' )
			{
				break;
			}
			szName[j] = pszPath[i];
		}
		for ( ; j < 8; j++ )
		{
			szName[j] = 0x20;
		}
		if ( pszPath[i] != '.' && i < iNameLen )	/* ե̾Ĺ */
		{
			SysMtx_Unlock(self->hMtx);
			return HANDLE_NULL;
		}
		
		/* ĥ */
		if ( pszPath[i] == '.' )
		{
			i++;
		}
		for ( j = 0; i < iNameLen && j < 3; i++, j++ )
		{
			szName[8+j] = pszPath[i];
		}
		for ( ; j < 3; j++ )
		{
			szName[8+j] = 0x20;
		}
		if ( i < iNameLen )		/* ĥĹ */
		{
			SysMtx_Unlock(self->hMtx);
			return HANDLE_NULL;
		}
		

		/* ݥ󥿤ʤ */
		pszPath += iNameLen;

		
		/* ʸѴ */
		for ( i = 0; i < 8+3; i++ )
		{
			/* ʸ */
			if ( szName[i] >= 'a' && szName[i] <= 'z')
			{
				szName[i] -= ('a' - 'A');
			}
		}
		if ( szName[0] == 0xe5 )
		{
			szName[0] = 0x05;
		} 
				
		
		
		/* ǥ쥯ȥ򳫤 */
		uiDirStartCluster = uiFileCluster;
		uiDirCluster      = uiDirStartCluster;
		uiDirEntryPos     = 0;
		if ( (pClusterBuf = FatVol_GetClusterBuf(self, uiDirCluster, 1)) == NULL )
		{
			SysMtx_Unlock(self->hMtx);
			return HANDLE_NULL;
		}
		
		/* ǥ쥯ȥꥨȥ򸡺 */
		iEntryHit = 0;
		for ( ; ; )
		{
			/* ǥ쥯ȥꥨȥ */
			pubBuf = &pClusterBuf->pubBuf[uiDirEntryPos];
			
			/* 0ʤǤڤ */
			if ( pubBuf[0] == 0x00 )
			{
				break;
			}
			
			/* ̾ */
			if ( memcmp(pubBuf, szName, 8+3) == 0 )
			{
				/* ϥ饹 */
				uiFileCluster = pubBuf[26] + (pubBuf[27] << 8);
				if ( self->iFatType == FATVOL_TYPE_FAT32 )
				{
					uiFileCluster += (pubBuf[20] << 16) + (pubBuf[21] << 24);
				}
				
				/* ° */ 
				ubFileAttr = pubBuf[11];
				
				/*  */
				FileSize = pubBuf[28] + (pubBuf[29] << 8) + (pubBuf[30] << 16) + (pubBuf[31] << 24);
				
				iEntryHit = 1;
				break;
			}
			
			/*  */
			uiDirEntryPos += 32;
			if ( uiDirEntryPos >= self->BytesPerCluster )
			{
				FatVol_RelClusterBuf(self, pClusterBuf, 0);
				uiDirCluster = FatVol_GetNextCluster(self, uiDirCluster);
				if ( uiDirCluster == FATVOL_CLUSTER_ENDMARKER
					|| (pClusterBuf = FatVol_GetClusterBuf(self, uiDirCluster, 1)) == NULL )
				{
					SysMtx_Unlock(self->hMtx);
					return HANDLE_NULL;
				}
				uiDirEntryPos = 0;
			}
		}
		
		/* ǥ쥯ȥĤ */
		FatVol_RelClusterBuf(self, pClusterBuf, 0);
		
		
		/* ʾ峫֥ǥ쥯ȥ꤬ʤȴ */
		if ( !(iEntryHit && (ubFileAttr & 0x10)) )
		{
			break;
		}
	}
	
	
	/* ѥ򤹤٤õǤƤʤNG */
	if ( *pszPath != '\0' )
	{
		SysMtx_Unlock(self->hMtx);
		return HANDLE_NULL;
	}
	
	
	/* ǥ쥯ȥ¸ߤʤ */
	if ( !iEntryHit )
	{
		/* ػߤʤХ顼 */
		if ( iMode & FILE_OPEN_EXIST )
		{
			SysMtx_Unlock(self->hMtx);
			return HANDLE_NULL;			
		}
				
		/* ǥ쥯ȥ򳫤 */
		uiDirCluster  = uiDirStartCluster;
		uiDirEntryPos = 0;
		if ( (pClusterBuf = FatVol_GetClusterBuf(self, uiDirCluster, 1)) == NULL )
		{
			SysMtx_Unlock(self->hMtx);
			return HANDLE_NULL;
		}
		
		/* õ */
		for ( ; ; )
		{
			/* ǥ쥯ȥꥨȥ */
			pubBuf = &pClusterBuf->pubBuf[uiDirEntryPos];
			
			/* ȯ */
			if ( pubBuf[0] == 0xe5 || pubBuf[0] == 0x00 )
			{
				break;
			}
			
			/*  */
			uiDirEntryPos += 32;
			if ( uiDirEntryPos >= self->BytesPerCluster )	/* 饹ۤʤ */
			{
				FatVol_RelClusterBuf(self, pClusterBuf, 0);
				uiDirCluster = FatVol_GetNextCluster(self, uiDirCluster);
				if ( uiDirCluster == FATVOL_CLUSTER_ENDMARKER )
				{
					/* FAT32ʳΥ롼ȥǥ쥯ȥʤĥǽ */
					if ( self->iFatType != FATVOL_TYPE_FAT32 && uiDirCluster >= 0x0f000000 )
					{
						SysMtx_Unlock(self->hMtx);
						return HANDLE_NULL;						
					}
					if ( (uiFileCluster = FatVol_AllocCluster(self)) == FATVOL_CLUSTER_ENDMARKER )
					{
						SysMtx_Unlock(self->hMtx);
						return HANDLE_NULL;						
					}
					FatVol_SetNextCluster(self, uiDirCluster, uiFileCluster);
					uiDirCluster = uiFileCluster;
				}
				if ( (pClusterBuf = FatVol_GetClusterBuf(self, uiDirCluster, 1)) == NULL )
				{
					SysMtx_Unlock(self->hMtx);
					return HANDLE_NULL;
				}
				uiDirEntryPos = 0;
			}
		}
		
		/* 饹 */
		if ( (uiFileCluster = FatVol_AllocCluster(self)) == FATVOL_CLUSTER_ENDMARKER )
		{
			FatVol_RelClusterBuf(self, pClusterBuf, 0);
			SysMtx_Unlock(self->hMtx);
			return HANDLE_NULL;			
		}
		FatVol_SetNextCluster(self, uiFileCluster, FATVOL_CLUSTER_ENDMARKER);
		
		MemUtil_MemSetB(&pubBuf[0], 0, 32);						/*  */
		MemUtil_MemCopyB(&pubBuf[0], szName, 8+3);				/* ե̾ */
		pubBuf[11] = (iMode & FILE_OPEN_DIR) ? 0x10 : 0x20;		/* ° */
		pubBuf[26] = ((uiFileCluster >>  0) & 0xff);			/* ϥ饹 */
		pubBuf[27] = ((uiFileCluster >>  8) & 0xff);
		pubBuf[20] = ((uiFileCluster >> 16) & 0xff);
		pubBuf[21] = ((uiFileCluster >> 24) & 0xff);
		FileSize   = 0;
		ubFileAttr = pubBuf[11];
		
		/* ǥ쥯ȥĤ */
		FatVol_RelClusterBuf(self, pClusterBuf, 1);
	}
	else
	{
		/* ¸ߤ */
		if ( iMode & FILE_OPEN_CREATE )
		{
			FatVol_FreeCluster(self, uiFileCluster);
			FatVol_SetNextCluster(self, uiFileCluster, FATVOL_CLUSTER_ENDMARKER);
			FileSize = 0;
		}
	}
	
	/* ⡼ɥå */
	if ( ((ubFileAttr & 0x10) && !(iMode & FILE_OPEN_DIR))
		|| (!(ubFileAttr & 0x10) && (iMode & FILE_OPEN_DIR)) )
	{
		SysMtx_Unlock(self->hMtx);
		return HANDLE_NULL;		
	}
	
	/* եǥץ */
	hFile = FatFile_Create(self, uiFileCluster, uiDirCluster, uiDirEntryPos, FileSize, iMode);
	if ( hFile != HANDLE_NULL )
	{
		self->iOpenCount++;
	}
	
	/* ƥ륻Ф */
	SysMtx_Unlock(self->hMtx);
	
	return hFile;
}


/* end of file */
