/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  stringformat.h
 * @brief %jp{ʸեޥå饤֥}
 *
 * %jp{ưʤɤεǽ¤Ĥ printf ܻؤ}
 *
 * Copyright (C) 2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef __HOS__stringformat_h__
#define __HOS__stringformat_h__


#include <stdarg.h>


#ifdef __cplusplus
extern "C" {
#endif

int StringFormat_FormatString(char *pszBuf, int iBufSize, const char *pszFormat, ...);
int StringFormat_FormatStringV(char *pszBuf, int iBufSize, const char *pszFormat, va_list argptr);

int StringFormat_Format(int (*pfncPut)(int c, void *Param), void *Param, const char *pszFormat, ...);										/* դ */	
int StringFormat_FormatV(int (*pfncPut)(int c, void *Param), void *Param, const char *pszFormat, va_list argptr);							/* դ(ꥹϤ) */

int StringFormat_Nibble(int (*pfncPut)(int c, void *Param), void *Param, unsigned char n);													/* 4bit16ʿ */
int StringFormat_Hexadecimal(int (*pfncPut)(int c, void *Param), void *Param, unsigned long ulNum, int iWidth, int iPadChar, int iFlag);	/* 16ʿ */
int StringFormat_Decimal(int (*pfncPut)(int c, void *Param), void *Param, long lNum, int iSigned, int iWidth, int iPadChar, int iFlag);		/* 10ʿ */
int StringFormat_String(int (*pfncPut)(int c, void *Param), void *Param, const char *pszStr, int iWidth, int iFlag);						/* ʸ */

#ifdef __cplusplus
}
#endif


#endif	/* __HOS__stringformat_h__ */


/* end of file */
