/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  stringformat.c
 * @brief %jp{ʸեޥå饤֥}
 *
 * Copyright (C) 2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include <string.h>
#include "stringformat_local.h"



/* ʸ */
int StringFormat_String(int (*pfncPut)(int c, void *Param), void *Param, const char *pszStr, int iWidth, int iFlag)
{
	int	iLen = 0;
	int	iSize = 0;
	int	iPadSize;
	
	/* ɽɬפʥ򻻽 */
	iSize = strlen(pszStr);
	
	/* ѥƥ󥰥 */
	iPadSize = iWidth - iSize;
	
	/* °̵˥ѥǥ */
	if ( iFlag != '-' )
	{
		while ( iPadSize > 0 )
		{
			if ( pfncPut(' ', Param) <= 0 )
			{
				return iLen;
			}
			iLen++;

			iPadSize--;
		}
	}
	
	/* ʸ */
	while ( iSize > 0 )
	{
		if ( pfncPut(*pszStr++, Param) <= 0 )
		{
			return iLen;
		}
		iLen++;
	
		iSize--;
	}
	
	
	/* °ʤѥǥ */
	if ( iFlag == '-' )
	{
		while ( iPadSize > 0 )
		{
			if ( pfncPut(' ', Param) <= 0 )
			{
				return iLen;
			}
			iLen++;

			iPadSize--;
		}
	}
	
	return iLen;
}


/* end of file */
