/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  arraybuf.h
 * @brief %jp{ꥹȥХåե饹}
 *
 * Copyright (C) 2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef __HOS__array_h__
#define __HOS__array_h__


#include "library/container/memheap/memheap.h"

/* 顼 */
#define ARRAY_ERR_OK			0
#define ARRAY_ERR_NG			(-1)

/* ĥñ */
#define ARRAY_SIZE_UNIT			16

typedef int		ARRAY_ERR;
typedef int		ARRAY_INDEX;


/* ȥ꡼Хåե饹 */
typedef struct c_array
{
	C_MEMHEAP	*pMemHeap;	/* ѤI/F */
	void		**ppArray;	/* ǡ */
	ARRAY_INDEX	ArraySize;	/* 󥵥 */
	ARRAY_INDEX	Size;		/* ǤΥ */
} C_ARRAY;


#ifdef __cplusplus
extern "C" {
#endif

/*  */
void        Array_Create(C_ARRAY *self);													/* 󥯥饹 */
void        Array_CreateEx(C_ARRAY *self, C_MEMHEAP *pMemHeap);								/* 󥯥饹 */
void        Array_Delete(C_ARRAY *self);													/* 󥯥饹κ */

/*  */
ARRAY_INDEX Array_GetSize(C_ARRAY *self);													/* 󥵥μ */
ARRAY_ERR   Array_SetSize(C_ARRAY *self, ARRAY_INDEX Size);									/* 󥵥 */
void        Array_Clear(C_ARRAY *self);														/* Υꥢ */
ARRAY_ERR   Array_Add(C_ARRAY *self, const void *pData, long lSize);						/* ǡɲ */
ARRAY_ERR   Array_SetAt(C_ARRAY *self, ARRAY_INDEX Index, const void *pData, long lSize);	/* ǡ */
void       *Array_GetAt(C_ARRAY *self, ARRAY_INDEX Index);									/* ǡ */

#ifdef __cplusplus
}
#endif


#endif	/* __HOS__array_h__ */


/* end of file */
