/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  assoc_remove.c
 * @brief %jp{Ϣ󥯥饹 ǡκ}
 *
 * Copyright (C) 2006-2009 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include <stdio.h>
#include <string.h>
#include "hosaplfw.h"
#include "assoc_local.h"



/** ǡκ */
ASSOC_ERR Assoc_Remove(C_ASSOC *self, const char *pszKey)
{
	T_ASSOC_NODE *pNode;
	
	if ( self->pRoot == NULL )
	{
		return ASSOC_ERR_NG;
	}
	
	/* Ρɼ */
	pNode = Assoc_GetNode(self, self->pRoot, pszKey);
	if ( pNode == NULL )
	{
		return ASSOC_ERR_NG;
	}
	
	/* Ρɺ */
	Assoc_RemoveNode(self, pNode);
	
	return 	ASSOC_ERR_OK;	
}


/* end of file */
