/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  automemheap_alloc.c
 * @brief %jp{ҡץ饹}%en{auto size memory heap class}
 *
 * Copyright (C) 2006-2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include <stdio.h>
#include "automemheap_local.h"



/** %jp{MemHeap饹 ۴ؿơ֥}%en{MemHeap class virtual function table} */
const static T_MEMHEAP_METHODS AutoMemHeap_Methods =
	{
		AutoMemHeap_Alloc,			/**< γ */
		AutoMemHeap_ReAlloc,		/**< κƳ */
		AutoMemHeap_Free,			/**< γ */
		AutoMemHeap_GetSize,		/**< Υ */
		AutoMemHeap_GetAlign,		/**< ꥢ饤Ȥμ */
		AutoMemHeap_AlignSize,		/**< 򥢥饤ñ̤˳ĥ */
	};



/** %jp{󥹥ȥ饯} */
void AutoMemHeap_Constructor(C_AUTOMEMHEAP *self, C_MEMHEAP *pMemHeap)
{
	/* %jp{ƥ饹󥹥ȥ饯} */
	MemHeap_Constructor(&self->MemHeap, &AutoMemHeap_Methods);
	
	/* ѿ */
	self->pValList = NULL;
	self->pFixList = NULL;
	self->pMemList = NULL;
	
	self->ValSize = 4096;
	self->FixSize = MemHeap_AlignSize(&self->MemHeap, 16);
	self->FixNum  = 4096 / self->FixSize;
	self->iValMax = 16;
	self->iFixMax = 16;
}


/* end of file */
