/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  automemheap_free.c
 * @brief %jp{ꥵҡץ饹}%en{fixed size memory heap class}
 *
 * Copyright (C) 2006-2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include <stdio.h>
#include "automemheap_local.h"


/** ǥȥ饯 */
void AutoMemHeap_Destructor(C_AUTOMEMHEAP *self)							
{
	T_AUTOMEMHEAP_FIX	*pFixHeap;
	T_AUTOMEMHEAP_FIX	*pFixHeapNext;
	T_AUTOMEMHEAP_VAL	*pValHeap;
	T_AUTOMEMHEAP_VAL	*pValHeapNext;
	T_AUTOMEMHEAP_MEM	*pMemHeap;
	T_AUTOMEMHEAP_MEM	*pMemHeapNext;
	
	
	/* Ĺҡ׳ */
	for ( pFixHeap = self->pFixList; pFixHeap != NULL; pFixHeap = pFixHeapNext )
	{
		pFixHeapNext = pFixHeap->pNext;
		MemHeap_Free(self->pMemHeap, pFixHeap);
	}
	
	/* Ĺҡפ̵õ */
	for ( pValHeap = self->pValList; pValHeap != NULL; pValHeap = pValHeapNext )
	{
		pValHeapNext = pValHeap->pNext;
		MemHeap_Free(self->pMemHeap, pValHeap);
	}
	
	/* ҡפ˳ */
	for ( pMemHeap = self->pMemList; pMemHeap != NULL; pMemHeap = pMemHeapNext )
	{
		pMemHeapNext = pMemHeap->pNext;
		MemHeap_Free(self->pMemHeap, pMemHeap);
	}
}


/* end of file */
