/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  fixmemheap_alloc.c
 * @brief %jp{ꥵҡץ饹}%en{fixed size memory heap class}
 *
 * Copyright (C) 2006-2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include <stdio.h>
#include "fixmemheap_local.h"



/** %jp{γ} */
void *FixMemHeap_Alloc(void *pMemHeap, MEMSIZE Size)
{
	C_FIXMEMHEAP	*self;
	void			*pMem;
	
	/* upper cast */
	self = (C_FIXMEMHEAP *)pMemHeap;
	
	/* %jp{ҡפ¸ߥå} */
	if ( self->pMemBase == NULL )
	{
		return NULL;
	}
	
	/* å */	
	if ( Size > self->BlkSize )
	{
		return NULL;
	}
	
	/* %jp{å} */
	if ( self->ppFree == NULL )
	{
		return NULL;		
	}
	
	/* ꥹȷҤѤ */
	pMem = self->ppFree;
	self->ppFree = *self->ppFree;
	
	return pMem;
}

/* end of file */
