/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  fixmemheap_alloc.c
 * @brief %jp{ꥵҡץ饹}%en{fixed size memory heap class}
 *
 * Copyright (C) 2006-2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include <stdio.h>
#include "fixmemheap_local.h"



/** %jp{MemHeap饹 ۴ؿơ֥}%en{MemHeap class virtual function table} */
const static T_MEMHEAP_METHODS FixMemHeap_Methods =
	{
		FixMemHeap_Alloc,			/**< γ */
		FixMemHeap_ReAlloc,			/**< κƳ */
		FixMemHeap_Free,			/**< γ */
		FixMemHeap_GetSize,			/**< Υ */
		FixMemHeap_GetAlign,		/**< ꥢ饤Ȥμ */
		FixMemHeap_AlignSize,		/**< 򥢥饤ñ̤˳ĥ */
		FixMemHeap_IsMember,		/**< ꤬ҡפ°Ƥ뤫å */
	};



/** %jp{󥹥ȥ饯} */
void FixMemHeap_Constructor(C_FIXMEMHEAP *self, void *pMemBase, MEMSIZE BlkSize,  MEMSIZE BlkNum)
{
	void	**ppBlk;
	void	**ppBlkNext;
	MEMSIZE i;

	/* %jp{ƥ饹󥹥ȥ饯} */
	MemHeap_Constructor(&self->MemHeap, &FixMemHeap_Methods);
	
	/* ѿ */
	self->pMemBase  = pMemBase;				/**< %jp{Ƭ֥åΥɥ쥹} */
	self->BlkSize   = BlkSize;				/**< %jp{֥å} */
	self->BlkNum    = BlkNum;				/**< %jp{֥åĿ} */
	
	/*  */
	ppBlk = (void **)self->pMemBase;
	for ( i = 0; i < BlkNum - 1; i++ )
	{
		ppBlkNext = (void **)((char *)ppBlk + BlkSize);
		*ppBlk    = (void *)ppBlkNext;
		ppBlk     = ppBlkNext;
	}
	*ppBlk = NULL;
	
	self->ppFree = (void **)self->pMemBase;
}


/* end of file */
