/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  hashtable_get.c
 * @brief %jp{ϥåơ֥륯饹}%en{hash table class}
 *
 * Copyright (C) 2006-2009 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include <stdio.h>
#include <string.h>
#include "hashtable_local.h"


/* ǡλ */
const void *HashTable_Get(C_HASHTABLE *self, const char *pszKey)
{
	T_HASHTABLE_NODE	*pNode;
	T_HASHTABLE_NODE	*pNodePrev;
	int					iIndex;
	
	/* õ */
	if ( (pNode = HashTable_SearchNode(self, pszKey, &pNodePrev, &iIndex)) == NULL )
	{
		return NULL;
	}
	
	/* ǡ֤ */
	return (const void *)((char *)pNode + sizeof(T_HASHTABLE_NODE) + MemHeap_AlignSize(self->pMemHeap, strlen(pszKey)));
}


/* end of file */
