/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  hashtable_get.c
 * @brief %jp{ϥåơ֥륯饹}%en{hash table class}
 *
 * Copyright (C) 2006-2009 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include <stdio.h>
#include <string.h>
#include "hashtable_local.h"



/** ǡκ */
void HashTable_RemoveAll(C_HASHTABLE *self)
{
	T_HASHTABLE_NODE		*pNode;
	T_HASHTABLE_NODE		*pNodeNext;
	T_HASHTABLE_ITERATOR	*pIterator;
	int						iIndex;
	
	for ( iIndex = 0; iIndex < self->iTableSize; iIndex++ )
	{
		if ( (pNode = self->ppTable[iIndex]) != NULL )
		{
			do
			{
				/* ؤƤ륤ƥ졼г */
				if ( (pIterator = pNode->pIterator) != NULL )
				{
					do
					{
						pIterator->iIndex = self->iTableSize;
						pIterator->pNode  = NULL;
						pIterator = pIterator->pNext;
					} while ( pIterator != pNode->pIterator );
				}

				/* Ρɺ */
				pNodeNext = pNode->pNext;
				HashTable_DeleteNode(self, pNode);
				self->iDataNum--;

				pNode = pNodeNext;
			} while ( pNode != NULL );			
			
			self->ppTable[iIndex] = NULL;
		}
	}
}



/* end of file */
