/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  streambuf.h
 * @brief %jp{ȥ꡼ǡѥХåե饹}
 *
 * Copyright (C) 2002-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef __HOS__streambuf_h__
#define __HOS__streambuf_h__


/* ȥ꡼Хåե饹 */
typedef struct c_streambuf
{
	unsigned char			*pubBuf;	/**< ХåեΰƬɥ쥹 */
	unsigned int			uiBufSize;	/**< ХåեΰΥ */
	volatile unsigned int	uiHead;		/**< ǡƬ */
	volatile unsigned int	uiTail;		/**< ǡ */
} C_STREAMBUF;


#ifdef __cplusplus
extern "C" {
#endif

/*  */
void         StreamBuf_Create(C_STREAMBUF *self, unsigned int uiBufSize, void *pBuf);		/**< 󥹥ȥ饯 */
#define      StreamBuf_Delete(self)	do {} while(0)											/**< ǥȥ饯 */

/* ǡ */
unsigned int StreamBuf_SendData(C_STREAMBUF *self, const void *pData, unsigned int uiSize);	/**< ǡ */
unsigned int StreamBuf_GetBuf(C_STREAMBUF *self, void **ppBuf);								/**< ѥХåեμ(ʥԡ) */
void         StreamBuf_SendBuf(C_STREAMBUF *self, unsigned int uiSize);						/**< ХåեΥǡ(ʥԡ) */
int          StreamBuf_SendChar(C_STREAMBUF *self, int c);									/**< 饯 */

/* ǡ */
unsigned int StreamBuf_RecvData(C_STREAMBUF *self, void *pBuf, unsigned int uiSize);		/**< ǡμ */
unsigned int StreamBuf_RecvBuf(C_STREAMBUF *self, void **ppBuf);							/**< ǡäХåեμ(ʥԡ) */
void         StreamBuf_RelBuf(C_STREAMBUF *self, unsigned int uiSize);						/**< ѥХåեβ(ʥԡ) */
int          StreamBuf_RecvChar(C_STREAMBUF *self);											/**< 饯μ */

/*  */
void         StreamBuf_Clear(C_STREAMBUF *self);											/**< ХåեΥꥢ */
unsigned int StreamBuf_RefDataSize(C_STREAMBUF *self);										/**< Хåե̤λ */
unsigned int StreamBuf_RefFreeSize(C_STREAMBUF *self);

#define      StreamBuf_RefMaxSize(self)		((self)->uiBufSize - 1)							/**< Ǽǽ */
#define      StreamBuf_RefBufAddr(self)		((void *)(self)->pubBuf)						/**< Хåեɥ쥹λ */
#define      StreamBuf_RefBufSize(self)		((self)->uiBufSize)								/**< Хåեǡ̤λ */

#ifdef __cplusplus
}
#endif



#endif	/* __HOS__streambuf_h__ */


/* end of file */
