/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  valmemheap_local.h
 * @brief %jp{ѥҡץ饹}%en{variable size memory heap class}
 *
 * Copyright (C) 2006-2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#ifndef __HOS__valmemheap_local_h__
#define __HOS__valmemheap_local_h__


#include "library/container/memheap/memheap_local.h"


#define VALMEMHEAP_USING		0x1234			/**< %jp{} */
#define VALMEMHEAP_FREE			0xabcd			/**< %jp{̤} */


/** %jp{ҡץ֥å} */
typedef struct t_valmemheap_memblk
{
	struct t_valmemheap_memblk*	pPrev;			/**< %jp{Υ֥å} */
	MEMSIZE						Size;			/**< %jp{֥åΥ} */
	int							iFlag;			/**< %jp{ե饰} */
} T_VALMEMHEAP_MEMBLK;


/** %jp{ValMemHeap饹}%en{ValMemHeap class} */
typedef struct c_valmemheap
{
	C_MEMHEAP			MemHeap;		/* Ѿ */
	
	T_VALMEMHEAP_MEMBLK	*pMemBase;		/**< %jp{Ƭ֥åΥɥ쥹} */
	MEMSIZE				MemSize;		/**< %jp{ꥵ} */
	int					AlignMask;		/**< %jp{ꥢ饤ȥ} */
} C_VALMEMHEAP;


#ifdef __cplusplus
extern "C" {
#endif

void	ValMemHeap_Constructor(C_VALMEMHEAP *self, void *pMemBase, MEMSIZE MemSize, int AlignSize);
#define ValMemHeap_Destructor(self)			do { } while (0)

void	*ValMemHeap_Alloc(void *pMemHeap, MEMSIZE Size);					/**< γ */
void	*ValMemHeap_ReAlloc(void *pMemHeap, void *pMem, MEMSIZE Size);		/**< κƳ */
void	ValMemHeap_Free(void *pMemHeap, void *pMem);						/**< γ */
MEMSIZE	ValMemHeap_GetSize(void *pMemHeap, void *pMem);						/**< Υ */
MEMSIZE	ValMemHeap_GetAlign(void *pMemHeap);								/**< ꥢ饤Ȥμ */
MEMSIZE	ValMemHeap_AlignSize(void *pMemHeap, MEMSIZE Size);					/**< 򥢥饤ñ̤˳ĥ */
int     ValMemHeap_IsMember(void *pMemHeap, void *pMem);					/**< ꤬ҡפ°Ƥ뤫å */

#define ValMemHeap_GetMemBlockSize(self)	(ValMemHeap_AlignSize((self), sizeof(T_VALMEMHEAP_MEMBLK)))

#ifdef __cplusplus
}
#endif



#endif	/* __HOS__valmemheap_local_h__ */


/* end of file */
