/** 
 *  Sample program for Hyper Operating System V4 Advance
 *
 * @file  ostimer.c
 * @brief %jp{OS}%en{OS timer}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "kernel.h"
#include "ostimer.h"


#define T0LD	((volatile UH *)0xffff0300)
#define T0VAL	((volatile UH *)0xffff0304)
#define T0CON	((volatile UW *)0xffff0308)
#define T0CLRI	((volatile UB *)0xffff030C)


static void OsTimer_Isr(VP_INT exinf);	/**< %jp{޳ߥӥ롼} */


/** %jp{OSѥ޽롼} */
void OsTimer_Initialize(VP_INT exinf)
{
	T_CISR cisr;
	
	/* %jp{ߥӥ롼} */
	cisr.isratr = TA_HLNG;
	cisr.exinf  = 0;
	cisr.intno  = 2;
	cisr.isr    = (FP)OsTimer_Isr;
	acre_isr(&cisr);
	ena_int(2);
	
	/* %jp{ư} */
	*T0LD  = 41779 - 1;		/* 41.7792MHz / 41779 = 1ms */
	*T0CON = 0xc0;
}


/** %jp{޳ߥϥɥ} */
void OsTimer_Isr(VP_INT exinf)
{
	/* %jp{װꥢ} */
	*T0CLRI = 0;
	
	/* %jp{ƥå} */
	isig_tim();
}


/* end of file */
