# ----------------------------------------------------------------------------
# Hyper Operating System
#
# Copyright (C) 1998-2008 by Project HOS
# http://sourceforge.jp/projects/hos/
# ----------------------------------------------------------------------------


# %jp{å̾}
TARGET = sample

# %jp{ǥ쥯ȥ}
OS_DIR             = ..\..\..\..\..
KERNEL_DIR         = $(OS_DIR)\kernel
KERNEL_CFGRTR_DIR  = $(OS_DIR)\cfgrtr\build\msc
KERNEL_MAKINC_DIR  = $(KERNEL_DIR)\build\common\nmake
KERNEL_BUILD_DIR   = $(KERNEL_DIR)\build\arm\lpc2000\armcc
HOSAPLFW_DIR       = $(OS_DIR)\aplfw
HOSAPLFW_INC_DIR   = $(HOSAPLFW_DIR)
HOSAPLFW_BUILD_DIR = $(HOSAPLFW_DIR)\build\arm\arm_v4t\armcc


# %jp{ɹ}
!include $(KERNEL_MAKINC_DIR)\common.inc


# %jp{ե졼}
KERNEL_CFGRTR = $(KERNEL_CFGRTR_DIR)\h4acfg-lpc2000


# %jp{饤֥}
HOSAPLFW_LIB = $(HOSAPLFW_BUILD_DIR)\hosaplfw.$(EXT_LIB)


# %jp{ǥХåǤѹ}
!if "$(DEBUG)" == "Yes"
HOSAPLFW_LIB = $(HOSAPLFW_BUILD_DIR)\hosaplfwdbg.$(EXT_LIB)
!endif


# %jp{ޥå}
!if "$(MEMMAP)" == "ext"
# %jp{}
TARGET      = $(TARGET)ext
SECTION_ROM = 0x80008000
SECTION_RAM = 0x80010000
!else
!if "$(MEMMAP)" == "ram"
# %jp{¢RAM}
SECTION_ROM = 0x00000000
SECTION_RAM = 0x80010000
!else
# %jp{¢ROM}
AFLAGS      = $(AFLAGS) --predefine="ROM_AT_ADDRESS_ZERO SETL {TRUE}"
SECTION_ROM = 0x00000000
SECTION_RAM = 0x80010000
!endif
!endif



# %jp{ե饰}
CFLAGS  = --cpu=ARM7TDMI-S --apcs=inter --thumb
AFLAGS  = --cpu=ARM7TDMI-S --apcs=inter --thumb
LNFLAGS = --ro_base=$(SECTION_ROM) --rw_base=$(SECTION_RAM) --first=vectors.o --entry=$(SECTION_ROM)


# %jp{ϥե̾}
TARGET_EXE = $(TARGET).$(EXT_EXE)
TARGET_BIN = $(TARGET).$(EXT_BIN)
TARGET_HEX = $(TARGET).$(EXT_HEX)


# %jp{ѥ¸ɹ}
!include $(KERNEL_MAKINC_DIR)\armcc_d.inc

# %jp{¹ԥեɹ}
!include $(KERNEL_MAKINC_DIR)\makexe_d.inc


# %jp{󥯥롼ɥǥ쥯ȥ}
INC_DIRS = $(INC_DIRS) $(HOSAPLFW_INC_DIR)


# %jp{ǥ쥯ȥ}
SRC_DIRS = $(SRC_DIRS) . ..


# %jp{֥եɲ}
ASRCS = $(ASRCS) .\vectors.s
ASRCS = $(ASRCS) .\startup.s
ASRCS = $(ASRCS) .\uish.s


# %jp{Cեɲ}
CSRCS = $(CSRCS) ..\kernel_cfg.c
CSRCS = $(CSRCS) ..\main.c
CSRCS = $(CSRCS) ..\boot.c
CSRCS = $(CSRCS) ..\ostimer.c


# %jp{֥ȥեɲ}
OBJS = $(OBJS) $(OBJS_DIR)\vectors.$(EXT_OBJ)
OBJS = $(OBJS) $(OBJS_DIR)\startup.$(EXT_OBJ)
OBJS = $(OBJS) $(OBJS_DIR)\uish.$(EXT_OBJ)
OBJS = $(OBJS) $(OBJS_DIR)\kernel_cfg.$(EXT_OBJ)
OBJS = $(OBJS) $(OBJS_DIR)\main.$(EXT_OBJ)
OBJS = $(OBJS) $(OBJS_DIR)\boot.$(EXT_OBJ)
OBJS = $(OBJS) $(OBJS_DIR)\ostimer.$(EXT_OBJ)


# %jp{饤֥եɲ}
LIBS = $(LIBS) $(HOSAPLFW_LIB)



# --------------------------------------
#  %jp{롼}
# --------------------------------------

all: make_subproject kernel_make make_subprj makeexe_all $(OBJS_DIR)\kernel_cfg.c srcobjcp $(TARGET_EXE)

make_subproject:
	$(CMD_CD) $(HOSAPLFW_BUILD_DIR)
	$(MAKE) -f nmake.mak
	$(CMD_CD) $(MAKEDIR)

clean: makeexe_clean
	-$(CMD_RM) $(TARGET_EXE) $(TARGET_EXE) $(OBJS) ..\kernel_cfg.c ..\kernel_id.h

mostlyclean: clean kernel_clean
	$(CMD_CD) $(HOSAPLFW_BUILD_DIR)
	$(MAKE) -f nmake.mak clean
	$(CMD_CD) $(MAKEDIR)


..\kernel_cfg.c ..\kernel_id.h: ..\system.cfg
	cl /E ..\system.cfg > ..\system.i
	$(KERNEL_CFGRTR) ..\system.i -c ..\kernel_cfg.c -i ..\kernel_id.h

$(OBJS_DIR)\kernel_cfg.c: ..\kernel_cfg.c
	$(CMD_CP) ..\kernel_cfg.c $(OBJS_DIR)
	$(CMD_CP) ..\kernel_id.h $(OBJS_DIR)


# %jp{¹ԥե̥롼ɹ}
!include $(KERNEL_MAKINC_DIR)\makexe_r.inc

# %jp{ѥ¸Υ롼ɹ}
!include $(KERNEL_MAKINC_DIR)\armcc_r.inc



# %jp{ԡ}
srcobjcp:
	$(CMD_CP) ..\*.c $(OBJS_DIR)
	$(CMD_CP) .\*.s $(OBJS_DIR)



# --------------------------------------
#  %jp{¸ط}
# --------------------------------------

$(OBJS_DIR)\vectors.$(EXT_OBJ)		:	$(OBJS_DIR)\vectors.s
$(OBJS_DIR)\startup.$(EXT_OBJ)		:	$(OBJS_DIR)\startup.s
$(OBJS_DIR)\uish.$(EXT_OBJ)			:	$(OBJS_DIR)\uish.s
$(OBJS_DIR)\kernel_cfg.$(EXT_OBJ)	:	$(OBJS_DIR)\kernel_cfg.c ..\kernel_id.h
$(OBJS_DIR)\main.$(EXT_OBJ)			:	$(OBJS_DIR)\main.c       ..\kernel_id.h
$(OBJS_DIR)\boot.$(EXT_OBJ)			:	$(OBJS_DIR)\boot.c       ..\kernel_id.h ..\boot.h
$(OBJS_DIR)\ostimer.$(EXT_OBJ)		:	$(OBJS_DIR)\ostimer.c    ..\kernel_id.h ..\ostimer.h


# end of file
