# ----------------------------------------------------------------------------
# Hyper Operating System V4 Advance
#  
# 
# Copyright (C) 1998-2007 by Project HOS
# http://sourceforge.jp/projects/hos/
# ----------------------------------------------------------------------------


# %jp{å̾}
TARGET ?= sample

# %jp{ǥ쥯ȥ}
TOP_DIR            = ../../../../..
KERNEL_DIR         = $(TOP_DIR)/kernel
KERNEL_CFGRTR_DIR  = $(TOP_DIR)/cfgrtr/build/gcc
KERNEL_MAKINC_DIR  = $(KERNEL_DIR)/build/common/gmake
KERNEL_BUILD_DIR   = $(KERNEL_DIR)/build/arm/at91/armcc
HOSAPLFW_DIR       = $(TOP_DIR)/aplfw
HOSAPLFW_INC_DIR   = $(HOSAPLFW_DIR)
HOSAPLFW_BUILD_DIR = $(HOSAPLFW_DIR)/build/arm/arm_v4t/armcc
OBJS_DIR           = objs_$(TARGET)


# %jp{ɹ}
include $(KERNEL_MAKINC_DIR)/common.inc


# %jp{ե졼}
KERNEL_CFGRTR = $(KERNEL_CFGRTR_DIR)/h4acfg-at91


# %jp{饤֥}
HOSAPLFW_LIB = $(HOSAPLFW_BUILD_DIR)/hosaplfw.a


# %jp{ǥХåǤѹ}
ifeq ($(DEBUG),Yes)
TARGET := $(TARGET)dbg
HOSAPLFW_LIB = $(HOSAPLFW_BUILD_DIR)/hosaplfwdbg.a
endif


# %jp{ͥեå}
KERNEL_HOK_TSK = Yes
KERNEL_HOK_ISR = Yes


# %jp{ե饰}
CFLAGS  += --cpu=ARM7TDMI --apcs=inter --thumb
AFLAGS  += --cpu=ARM7TDMI --apcs=inter --thumb
LNFLAGS += --ro_base=0x20000000 --first=vectors.o\(Init\) --entry=0x20000000


# %jp{ϥե̾}
TARGET_EXE = $(TARGET).axf
TARGET_MOT = $(TARGET).mot
TARGET_HEX = $(TARGET).hex


# %jp{armccѤɹ}
include $(KERNEL_MAKINC_DIR)/armcc_d.inc


# %jp{󥯥롼ɥǥ쥯ȥ}
INC_DIRS += $(HOSAPLFW_INC_DIR)

# %jp{ǥ쥯ȥ}
SRC_DIRS += . ..


# %jp{֥եɲ}
ASRCS += ./vectors.s		\
         ./startup.s		\
         ./uish.s


# %jp{Cեɲ}
CSRCS += ../kernel_cfg.c	\
         ../main.c			\
         ../boot.c			\
         ../ostimer.c

# %jp{饤֥եɲ}
LIBS += $(HOSAPLFW_LIB)



# --------------------------------------
#  %jp{롼}
# --------------------------------------

.PHONY : all
all: make_libs makeexe_all $(TARGET_EXE) $(TARGET_MOT) $(TARGET_HEX)

.PHONY : make_libs
make_libs:
	$(MAKE) -C $(HOSAPLFW_BUILD_DIR) -f gmake.mak

.PHONY : clean
clean: makeexe_clean
	rm -f $(TARGET_EXE) $(TARGET_EXE) $(OBJS) ../kernel_cfg.c ../kernel_id.h

.PHONY : mostlyclean
mostlyclean: clean kernel_clean
	$(MAKE) -C $(HOSAPLFW_BUILD_DIR) -f gmake.mak clean

.PHONY : depend
depend: makeexe_depend

.PHONY : mostlydepend
mostlydepend: depend kernel_depend
	$(MAKE) -C $(HOSAPLFW_BUILD_DIR) -f gmake.mak depend


../kernel_cfg.c ../kernel_id.h: ../system.cfg
	cpp -E ../system.cfg ../system.i
	$(KERNEL_CFGRTR) ../system.i -c ../kernel_cfg.c -i ../kernel_id.h



# %jp{饤֥ɹ}
include $(KERNEL_MAKINC_DIR)/makeexe.inc

# %jp{armccѤΥ롼ɹ}
include $(KERNEL_MAKINC_DIR)/armcc_r.inc



# --------------------------------------
#  %jp{¸ط}
# --------------------------------------

$(OBJS_DIR)/sample.obj: ../sample.c ../kernel_id.h


# end of file
