/** 
 * Hyper Operating System V4 Advance
 *
 *  Sample program for PC/AT
 *
 * Copyright (C) 1998-2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



IPL_SEG   = 0x07c0			/* ɤ륻ȥɥ쥹 */
LOAD_SEG  = 0x0800			/* Τɤ륻ȥɥ쥹 */
IPL_ADDR  = (IPL_SEG << 4)
LOAD_ADDR = (LOAD_SEG << 4)

LOAD_SEC_NUM = 128


				.code16
				.text
				.org	0

				.global	ipl_top

		/***** IPL *****/
ipl_top:
				cli
				jmpl	$IPL_SEG, $ipl_start	/* CSν */
ipl_start:
				movw	$IPL_SEG, %ax
				movw	%ax, %ds				/* DSν */
				movw	%ax, %ss				/* SSν */
				movw	$0x200, %ax
				movw	%ax, %sp				/* SPν */

		/*****  *****/
init_start:
				/* ̤Υꥢ */
				call	bios_clr_disp
				
				/* å */
				movw    $boot_message, %si
				call	bios_puts
				
				/* ΤΥ */
				movw	$LOAD_SEG, %ax
				movw	%ax, %es
				xorw	%bx, %bx			/* ɹ襢ɥ쥹 */
				movw	$1, %ax				/* ɤ߹ֹ */
read_loop:		
				pushw	%ax
				pushw	%bx
				pushw	%es
				call	read_sector
				popw	%es
				popw	%bx
				popw	%ax
				
				addw	$1, %ax
				addw	$512, %bx
				cmp		$LOAD_SEC_NUM, %ax
				jnz		read_loop
				
				/* ͥƥ֥⡼ɤذܹ */
				jmp		switch_32bit
				
				
				/* 顼 */
disk_error:		
				movw    $error_message, %si
				call	bios_puts
error_end:		
				nop
				jmp		error_end


read_sector:
				/* FDD飱ɤ߹ */
				pushw	%bx
				mov		$18, %bl
				div		%bl
				popw	%bx
				
				xorw	%cx, %cx
				movb	%ah, %cl
				incb	%cl					/*  */
				
				movb	%al, %dh			/* إåֹ */
				andb	$0x01, %dh
				
				shrb	$1, %al
				mov		%al, %ch			/* ֹ */
				
				movb	$0x00, %dl			/* ɥ饤ֹ */
				
				movb	$0x02, %ah			/* ǽ */
				movb	$1, %al				/*  */
				int		$0x13
				jc		disk_error
				cmp		$1, %al
				jnz		disk_error
				ret
				
				
				/* ̤Υꥢ */
bios_clr_disp:
				movb    $0x3, %al
				movb    $0, %ah
				int     $0x10
				ret


				/* ʸ */
bios_putc:
				movb    $0x0e, %ah
				movb    $0, %bh
				int     $0x10
				ret
				
				/* ʸ */
bios_puts:
				lodsb
				cmpb	$0, %al
				jz		bios_puts_end
				call	bios_putc
				jmp		bios_puts
bios_puts_end:
				ret


switch_32bit:
				cli
				
				/* GDT */
				lgdt	gdtr
				
				/* ץƥȥ⡼ɤذܹ */
				movl	%cr0, %eax
				orl		$0x00000001, %eax
				movl	%eax, %cr0
				
				/* ѥץ饤եå */
				.byte	0xe9, 0x00, 0x00
				
				/* CS */
				.byte	0xea
				.word	_start_32bit + IPL_ADDR
				.word	0x0008
				
				.code32
_start_32bit:	
				movw	$0x0010, %ax
				movw	%ax, %ss
				movw	%ax, %ds
				movw	%ax, %es
				movw	%ax, %fs
				movw	%ax, %gs
				
				movl	$LOAD_ADDR, %eax
				jmp		%eax



				/* ưå */
boot_message:
		        .ascii	"HOS-Loader\r\nNow loading...\r\n\0"

				/* 顼å */
error_message:
		        .ascii	"disk error\r\n\0"



/************************************************
  Хǥץơ֥
************************************************/

gdt_base:
gdt_000:		/* ̥륻 */
				.word	0x0000
				.word	0x0000
				.byte	0x00
				.byte	0x00
				.byte	0x00
				.byte	0x00

gdt_001:		/* ɥ */
				.word   0xffff		/* ߥå[15:0]:0xffff */
				.word   0x0000		/* ١[15:0]:0x0000 */
				.byte   0x00		/* ١[23:16] */
				.byte   0x9a		/* P:1, DPL:0, S:1, TYPE:5, A:0 */
				.byte   0xcf		/* G:1, D=1, ߥå[19:15]:0xf */
				.byte   0x00		/* ١[32:24]:0x00 */

gdt_002:		/* ǡ */		
				.word	0xffff		/* ߥå[15:0]:0xffff */
				.word	0x0000		/* ١[15:0]:0x0000 */
				.byte	0x00		/* ١[23:16] */
				.byte	0x92		/* P:1, DPL:0, S:1, TYPE:1, A:0 */
				.byte	0xcf		/* G:1, D=1, ߥå[19:15]:0xf */
				.byte	0x00		/* ١[32:24]:0x00 */
gdt_end:


				/* lgdt̿ΰ */
gdtr:			.word	gdt_end - gdt_base - 1
				.long	gdt_base + IPL_ADDR


				/* ޥåʥС */
				.org	510
				.word	0xaa55



/* end of file  */
