# ----------------------------------------------------------------------------
# Hyper Operating System V4 Advance
#
# Copyright (C) 2008 by Project HOS
# http://sourceforge.jp/projects/hos/
# ----------------------------------------------------------------------------


# %jp{å̾}
TARGET ?= sample

# %jp{ǥ쥯ȥ}
TOP_DIR             = ../../../../..
KERNEL_DIR          = $(TOP_DIR)/kernel
KERNEL_CFGRTR_DIR   = $(TOP_DIR)/cfgrtr/build/gcc
KERNEL_MAKINC_DIR   = $(KERNEL_DIR)/build/common/gmake
KERNEL_BUILD_DIR    = $(KERNEL_DIR)/build/mn103/mn103s/cc103
HOSAPLFW_DIR        = $(TOP_DIR)/aplfw
HOSAPLFW_INC_DIR    = $(HOSAPLFW_DIR)
HOSAPLFW_BUILD_DIR  = $(HOSAPLFW_DIR)/build/mn103/mn103s/cc103
OBJS_DIR            = objs_$(TARGET)


# %jp{ɹ}
include $(KERNEL_MAKINC_DIR)/common.inc


# %jp{ե졼}
KERNEL_CFGRTR = $(KERNEL_CFGRTR_DIR)/h4acfg-mn103s


# %jp{饤֥}
HOSAPLFW_LIB = $(HOSAPLFW_BUILD_DIR)/hosaplfw.$(EXT_LIB)



# %jp{ǥХåǤѹ}
ifeq ($(DEBUG),Yes)
TARGET := $(TARGET)dbg
HOSAPLFW_LIB = $(HOSAPLFW_BUILD_DIR)/hosaplfwdbg.$(EXT_LIB)
endif


# %jp{ե饰}
CFLAGS  = 
AFLAGS  = 
LNFLAGS = -g -Qld=-m -Qld=-Rl -Qld=-T@CODE=0x40000000 -Qld=-T@DATA=0x00000004


# %jp{ϥե̾}
TARGET_EXE = $(TARGET).$(EXT_EXE)
TARGET_BIN = $(TARGET).$(EXT_BIN)


# %jp{ѥ¸ɹ}
include $(KERNEL_MAKINC_DIR)/cc103_d.inc


# %jp{󥯥롼ɥǥ쥯ȥ}
INC_DIRS += $(HOSAPLFW_INC_DIR)

# %jp{ǥ쥯ȥ}
SRC_DIRS += . ..


# %jp{֥եɲ}
ASRCS += ./startup.as		\


# %jp{Cեɲ}
CSRCS += ../kernel_cfg.c	\
         ../main.c			\
         ../boot.c			\
         ../ostimer.c


# %jp{饤֥եɲ}
LIBS     += $(HOSAPLFW_LIB)
STD_LIBS += C:/PanaX/CC103S/LIB/CC103S.L



# --------------------------------------
#  %jp{롼}
# --------------------------------------

.PHONY : all
all: make_libs makeexe_all $(TARGET_EXE)


.PHONY : make_libs
make_libs:
	$(MAKE) -C $(HOSAPLFW_BUILD_DIR) -f gmake.mak

.PHONY : clean
clean: makeexe_clean
	rm -f $(TARGET_EXE) $(TARGET_EXE) $(OBJS) ../system.i ../kernel_cfg.c ../kernel_id.h

.PHONY : mostlyclean
mostlyclean: clean kernel_clean
	$(MAKE) -C $(HOSAPLFW_BUILD_DIR) -f gmake.mak clean

.PHONY : depend
depend: makeexe_depend

.PHONY : mostlydepend
mostlydepend: depend kernel_depend
	$(MAKE) -C $(HOSAPLFW_BUILD_DIR) -f gmake.mak depend

.PHONY : srccpy
srccpy: makeexe_srccpy

.PHONY : mostlysrccpy
mostlysrccpy: srccpy srccpy
	$(MAKE) -C $(KERNEL_BUILD_DIR) -f gmake.mak srccpy
	$(MAKE) -C $(HOSAPLFW_BUILD_DIR) -f gmake.mak srccpy


../kernel_cfg.c ../kernel_id.h: ../system.cfg $(KERNEL_CFGRTR)
	cpp -E ../system.cfg ../system.i
	$(KERNEL_CFGRTR) ../system.i -c ../kernel_cfg.c -i ../kernel_id.h



# %jp{饤֥ɹ}
include $(KERNEL_MAKINC_DIR)/makeexe.inc

# %jp{ѥ¸롼ɹ}
include $(KERNEL_MAKINC_DIR)/cc103_r.inc



# --------------------------------------
#  %jp{¸ط}
# --------------------------------------

$(OBJS_DIR)/sample.obj: ../sample.c ../kernel_id.h



# end of file
