/**
 *  Sample program for Hyper Operating System V4 Advance
 *
 * @file  sample.c
 * @brief %jp{ץץ}%en{Sample program}
 *
 * Copyright (C) 1998-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "kernel.h"
#include "kernel_id.h"
#include "hosaplfw.h"
#include "system/system/system.h"
#include "system/sysapi/sysapi.h"
#include "system/file/file.h"
#include "system/file/console.h"
#include "system/process/process.h"
#include "system/command/command.h"
#include "driver/serial/winsock/winsockdrv.h"
#include "driver/console/vt100/vt100drv.h"
#include "application/syscmd/shell/shell.h"
#include "application/example/hello/hello.h"
#include "boot.h"


long	g_SystemHeap[1 * 1024 * 1024 / sizeof(long)];


int Boot_Process(VPARAM Param);

/* ֡ȥ */
void Boot_Task(VP_INT exinf)
{
	T_SYSTEM_INITIALIZE_INF	SysInf;
	
	
	/*************************/
	/*                 */
	/*************************/
	
	/* ƥ */
	SysInf.pHeapMem        = g_SystemHeap;
	SysInf.HeapSize        = sizeof(g_SystemHeap);
	SysInf.SystemStackSize = 1024;
	SysInf.pfncBoot        = Boot_Process;
	SysInf.BootParam       = (VPARAM)0;
	SysInf.BootStackSize   = 4096;
	System_Initialize(&SysInf);
}




/* ֡ȥץ */
int Boot_Process(VPARAM Param)
{
	HANDLE	hTty;
	HANDLE	hCon;
	HANDLE	hDriver;
	

	/*************************/
	/*     ǥХɥϿ      */
	/*************************/

	/* WinSockѵꥢǥХɥ */
	hDriver = WinSockDrv_Create(9997, 1, 64);
	File_AddDevice("com0", hDriver);
	
	/* ߥʥ򳫤 */
	hTty = File_Open("/dev/com0", FILE_OPEN_READ | FILE_OPEN_WRITE);

	/* /dev/com0 ξ VT100󥽡 */
	hDriver = Vt100Drv_Create(hTty);
	File_AddDevice("con0", hDriver);

	/* 󥽡򳫤 */
	hCon = File_Open("/dev/con0", FILE_OPEN_READ | FILE_OPEN_WRITE);


	/*************************/
	/*     ɸ    */
	/*************************/
	
	Process_SetTerminal(HANDLE_NULL, hTty);
	Process_SetConsole(HANDLE_NULL, hCon);
	Process_SetStdIn(HANDLE_NULL, hCon);
	Process_SetStdOut(HANDLE_NULL, hCon);
	Process_SetStdErr(HANDLE_NULL, hCon);
	

	/*************************/
	/*     ޥϿ      */
	/*************************/
	Command_Initialize();
	Command_AddCommand("sh",     Shell_Main);
	Command_AddCommand("hello",  Hello_Main);
	
	
	/* ưå */
	StdIo_PutString(
			"\n\n"
			"================================================================\n"
			" Hyper Operating System  Application Framework\n"
			"\n"
			"                          Copyright (C) 1998-2008 by Project HOS\n"
			"                          http://sourceforge.jp/projects/hos/\n"
			"================================================================\n"
			"\n");
	
	/*************************/
	/*      뵯ư       */
	/*************************/
	
	Command_Execute("sh -i", NULL);

	return 0;
}



/* end of file */
