/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  file.h
 * @brief %jp{ե륷ƥ}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef __HOS__file_h__
#define __HOS__file_h__


#include <stdarg.h>
#include "system/handle/handleobj.h"


#define FILE_MAX_PATH						128			/* ѥ̾κ */
#define FILE_MAX_NAME						13			/* ̾κ */


/* 顼 */
#define FILE_ERR_OK							0			/* ｪλ*/
#define FILE_ERR_NG							(-1)		/* 顼 */
#define FILE_ERR_BUSY						(-2)		/* ¾Υץ(֥å󥰥⡼ɰʳǥݡ󥰼) */
#define FILE_ERR_BACKGROUND					(-3)		/* Хå饦ɤǽ */
#define FILE_ERR_TIMEOUT					(-4)		/* ॢ */

/*  */
#define FILE_EOF							(-1)

/* Open⡼ */
#define FILE_OPEN_READ						0x0001		/* ɹߵ */
#define FILE_OPEN_WRITE						0x0002		/* ߵ */
#define FILE_OPEN_CREATE					0x0004		/* ˿ */
#define FILE_OPEN_EXIST						0x0008		/* ¸ߤʤХ顼 */
#define FILE_OPEN_APPEND					0x0010		/* ¸ߤʤХ顼 */
#define FILE_OPEN_TEXT						0x0080		/* ƥȥ⡼ */
#define FILE_OPEN_SHARE_READ				0x0100		/* ɹ߶ͭ */
#define FILE_OPEN_SHARE_WRITE				0x0200		/* ߶ͭ */
#define FILE_OPEN_DIR						0x0800		/* ǥ쥯ȥ򥪡ץ */

/*  */
#define FILE_SEEK_SET						0
#define FILE_SEEK_CUR						1
#define FILE_SEEK_END						2


/* Ʊ⡼ */
#define FILE_SYNCMODE_BLOCKING				0x00		/* ֥å󥰥⡼ */
#define FILE_SYNCMODE_POLING				0x01		/* ݡ󥰥⡼ */
#define FILE_SYNCMODE_BACKGROUND			0x02		/* Хå饦ɼ¹ */

/* ƱΥ */
#define FILE_SYNCTYPE_NONE					0x00		/* ƱΤʤ */
#define FILE_SYNCTYPE_EVENT					0x01		/* ٥ */
#define FILE_SYNCTYPE_CALLBACK				0x02		/* Хå */


/* IoControlǽ() */
#define FILE_IOCTL_GETDEVINF				0x0000		/* ǥХ */
#define FILE_IOCTL_SYNC						0x0001		/* Ʊ */
#define FILE_IOCTL_GETSIZE					0x0010		/* ե륵 */
#define FILE_IOCTL_GETREADSIZE				0x0010		/* ɤ߹߲ǽ(ХåեΥǡ) */
#define FILE_IOCTL_GETWRITESIZE				0x0011		/* 񤭹߲ǽ(Хåեζ) */
#define FILE_IOCTL_GETREADBUF				0x0020		/* ꡼ɥХåե(ʥԡRead) */
#define FILE_IOCTL_RELREADBUF				0x0021		/* ꡼ɥХåեֵ(ʥԡRead) */
#define FILE_IOCTL_GETWRITEBUF				0x0030		/* 饤ȥХåե(ʥԡWrite) */
#define FILE_IOCTL_SENDWRITEBUF				0x0031		/* 饤ȥХåե(ʥԡWrite) */
#define FILE_IOCTL_CANWRITEBUF				0x0032		/* 饤ȥХåե˴(ʥԡWrite) */


/* IoControlǽ(Ʊ) */
#define FILE_IOCTL_SET_WRITE_SYNCMODE		0x0081		/* ߤƱ⡼ɤ */
#define FILE_IOCTL_SET_READ_SYNCMODE		0x0082		/* ɹߤƱ⡼ɤ */
#define FILE_IOCTL_SET_IOCTL_SYNCMODE		0x0083		/* I/OƱ⡼ɤ */

#define FILE_IOCTL_SET_WRITE_SYNCINF		0x0091		/* ߤƱ */
#define FILE_IOCTL_SET_READ_SYNCINF			0x0092		/* ɹߤƱ */
#define FILE_IOCTL_SET_IOCTL_SYNCINF		0x0093		/* I/OƱ */


/* IoControlǽ(ǥ쥯ȥ) */
#define FILE_IOCTL_DIR_READ					0x0101		/* ǥ쥯ȥ */


/* IoControlǽ(󥽡) */
#define FILE_IOCTL_CON_GETCH				0x0201		/* ʸɹ */

/* IoControlǽ(ꥢ̿) */
#define FILE_IOCTL_COM_GETSPEED				0x2101		/* BPS */
#define FILE_IOCTL_COM_SETSPEED				0x2101		/* BPS */

/* IoControlǽ(Ether) */
#define FILE_IOCTL_ETHER_GETPHA				0x2201		/* ʪɥ쥹 */
#define FILE_IOCTL_ETHER_SETPHA				0x2202		/* ʪɥ쥹 */

/* IoControlǽ(IP) */
#define FILE_IOCTL_IP_GETIP					0x2301		/* IPɥ쥹 */
#define FILE_IOCTL_IP_SETIP					0x2302		/* IPɥ쥹 */
#define FILE_IOCTL_IP_GETMASK				0x2303		/* IP֥ͥåȥޥ */
#define FILE_IOCTL_IP_SETMASK				0x2304		/* IP֥ͥåȥޥ */

/* IoControlǽ(桼) */
#define FILE_IOCTL_USER						0x6000		/* 0x60000x7fff */


/* ե° */
#define FILE_ATTR_READONLY					0x01
#define FILE_ATTR_HIDDEN					0x02
#define FILE_ATTR_SYSTEM					0x04
#define FILE_ATTR_DIR						0x10
#define FILE_ATTR_ARCHIVE					0x20
#define FILE_ATTR_DEVICE					0x80


/*  */
typedef char			FILE_ATTR;						/* ե° */
typedef int				FILE_ERR;						/* եΥ顼 */
typedef _HOS_SINT64		FILE_POS;						/* ե֤η */
typedef long			FILE_SIZE;						/* ɤ߽񤭻ΥѤη */
typedef unsigned long	FILE_TIME;						/* ɤ߽񤭻ΥѤλ﷿ */

struct c_drvobj;


/* ե */
typedef struct t_file_fileinf
{
	char		szFileName[FILE_MAX_NAME];
	FILE_ATTR	Attribute;
	FILE_POS	FileSize;

/*
	FILE_TIME	timeCreate;
	FILE_TIME	timeAceess;
	FILE_TIME	timeWrite;
*/

	char		szInformation[64];
} T_FILE_FILEINF;


/* Ʊ */
typedef struct t_file_syncinf
{
	int			Type;
	union
	{
		struct
		{
			void	(*pfncProc)(VPARAM Param, FILE_ERR ErrCode);
			VPARAM	Param;
		} Proc;
		HANDLE hEvent;
	} Sync;
} T_FILE_SYNCINF;


#include "fileobj.h"
#include "drvobj.h"


#ifdef __cplusplus
extern "C" {
#endif

/* ƥ */
void      File_Initialize(void);											/* ե륷ƥν */

FILE_ERR  File_AddDevice(const char *pszName, HANDLE hDriver);				/* ǥХɥ饤ФϿ */
FILE_ERR  File_RemoveDevice(const char *pszName);							/* ǥХɥ饤Фκ */
HANDLE    File_GetDevice(const char *pszName);								/* ǥХɥ饤Фμ */

FILE_ERR  File_AddVolume(const char *pszName, HANDLE hVolume);				/* ܥ塼Υޥ */
FILE_ERR  File_RemoveVolume(const char *pszName);							/* ܥ塼Υޥ */
HANDLE    File_GetVolume(const char *pszName);								/* ܥ塼μ */


/* API */
HANDLE    File_Open(const char *pszPath, int iMode);
void      File_Close(HANDLE hFile);
FILE_ERR  File_IoControl(HANDLE hFile, int iFunc, void *pInBuf, FILE_SIZE InSize, const void *pOutBuf, FILE_SIZE OutSize);
FILE_POS  File_Seek(HANDLE hFile, FILE_POS Offset, int iOrign);
FILE_SIZE File_Read(HANDLE hFile, void *pBuf, FILE_SIZE Size);
FILE_SIZE File_Write(HANDLE hFile, const void *pData, FILE_SIZE Size);
FILE_ERR  File_Flush(HANDLE hFile);

/* ǥХɥ饤ľ */
HANDLE    File_DriverOpen(HANDLE hDriver, const char *pszPath, int iMode);				/* ̵̾եΥץ */
FILE_ERR  File_GetDriverInformation(HANDLE hDriver, char *pszInformation, int iLen);	/* ǥХɥ饤о */


/* ƱAPI */
FILE_ERR  File_SetWriteMode(HANDLE hFile, int iWriteMode);
FILE_ERR  File_GetWriteStatus(HANDLE hFile);
FILE_ERR  File_SetWriteEvent(HANDLE hFile, HANDLE hEvent);
FILE_ERR  File_SetReadMode(HANDLE hFile, int iReadMode);
FILE_ERR  File_GetReadStatus(HANDLE hFile);
FILE_ERR  File_SetReadEvent(HANDLE hFile, HANDLE hEvent);
FILE_ERR  File_SetIoMode(HANDLE hFile, int iReadMode);
FILE_ERR  File_GetIoStatus(HANDLE hFile);
FILE_ERR  File_SetIoEvent(HANDLE hFile, HANDLE hEvent);


/* ʸAPI */
int       File_GetChar(HANDLE hFile);
int       File_GetString(HANDLE hFile, char *pszString, int iSize);
int       File_PutChar(HANDLE hFile, int c);
int       File_PutString(HANDLE hFile, const char *pszString);

/* դʸAPI */
int       File_PrintFormatV(HANDLE hFile, const char *pszFormat, va_list argptr);
int       File_PrintFormat(HANDLE hFile, const char *pszFormat, ...);

int       File_PrintHexNibble(HANDLE hFile, unsigned char c);							/* 4bit16ʿ */

int       File_PrintFormatDecimal(HANDLE hFile, long lNum, int iWidth, int iPadChar);	/* դ10ʿ */
int       File_PrintFormatVL(HANDLE hFile, const char *pszFormat, va_list argptr);		/* դϷ */


/* ǥ쥯ȥɤ߽Ф */
FILE_ERR  File_ReadDir(HANDLE hFile, T_FILE_FILEINF *pFileInf);


/* ĥ */
FILE_POS  File_GetFileSize(HANDLE hFile);
FILE_SIZE File_GetReadSize(HANDLE hFile);
FILE_SIZE File_GetWriteSize(HANDLE hFile);

FILE_SIZE File_GetReadBuf(HANDLE hFile, void **ppBuf);
FILE_SIZE File_RelReadBuf(HANDLE hFile, void *pBuf, FILE_SIZE Size);
FILE_SIZE File_GetWriteBuf(HANDLE hFile, void **ppBuf);
FILE_SIZE File_SendWriteBuf(HANDLE hFile, void *pBuf, FILE_SIZE Size);
FILE_ERR  File_CanWriteBuf(HANDLE hFile, void *pBuf);

/* ǥ쥯ȥ */
HANDLE    File_OpenDir(const char *pszName);											/**< ǥ쥯ȥ򳫤 */
FILE_ERR  File_ReadDir(HANDLE hDir, T_FILE_FILEINF *pFileInf);							/**< ǥ쥯ȥ꤫ե򸡺 */
HANDLE    File_MakeDir(const char *pszName);											/**< ֥ǥ쥯ȥ */
HANDLE    File_Remove(const char *pszName);												/**< ե */
FILE_ERR  File_RelPathToAbsPath(char *pszDstPath, const char *pszSrcPath, int iMaxLen);	/**< ХѥХѥѴ */


#ifdef __cplusplus
}
#endif


#endif	/* __HOS__file_h__ */


/* end of file */
