/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  syncdrv.h
 * @brief %jp{ƱǽդǥХɥ饤Фδܥ饹}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef __HOS__syncdrv_local_h__
#define __HOS__syncdrv_local_h__


#include "syncdrv.h"
#include "system/file/drvobj_local.h"
#include "system/sysapi/sysapi.h"



/* װ */
#define SYNCDRV_FACTOR_WRITE		0
#define SYNCDRV_FACTOR_READ			1
#define SYNCDRV_FACTOR_IOCTL		2

#define SYNCDRV_FACTOR_NUM			3

struct c_syncfile;

/* ǥХɥ饤Х֥ȴܥ饹(ݥ饹) */
typedef struct c_syncdrv
{
	C_DRVOBJ			DrvObj;				/**< DrvObj饹Ѿ */

	struct c_syncfile	*pFileHead;			/**< ե륪֥ȤϢݥ */
	
	SYSEVT_HANDLE		hMtx;				/**< ¾ߥ塼ƥå */
	
	int					iSyncFactorNum;		/**< Ʊװο */
	struct c_syncfile	**ppBusyFile;		/**< ե륪֥ */
} C_SYNCDRV;


#include "system/file/syncfile_local.h"


#ifdef __cplusplus
extern "C" {
#endif

FILE_ERR SyncDrv_Constructor(C_SYNCDRV *self, const T_DRVOBJ_METHODS *pMethods, int iSyncFactorNum);	/**< 󥹥ȥ饯 */
void     SyncDrv_Destructor(C_SYNCDRV *self);															/**< ǥȥ饯 */

#define  SyncDrv_GetSyncFactorNum(self)		((self)->iSyncFactorNum)									/**< Ʊװ */

FILE_ERR SyncDrv_StartProcess(C_SYNCDRV *self, struct c_syncfile *pSyncFile, int iFactor);				/**< γ */
void     SyncDrv_EndProcess(C_SYNCDRV *self, int iFactor, VPARAM ErrCode);								/**< δλ */
void     SyncDrv_SendSignal(C_SYNCDRV *self, int iFactor);												/**< ʥ */

FILE_ERR SyncDrv_IoControl(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj, int iFunc, void *pInBuf, FILE_SIZE InSize, const void *pOutBuf, FILE_SIZE OutSize);

#ifdef __cplusplus
}
#endif


#endif	/* __HOS__drvobj_h__ */


/* end of file */
