/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  syncfile.h
 * @brief %jp{ƱǽդǥХɥ饤дܥ饹}
 *
 * %jp{եǥץȤƵǽ륯饹}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "hosaplfw.h"
#include "syncdrv_local.h"
#include "system/system/system.h"


static void SyncDrv_SendSignalProc(VPARAM Param1, VPARAM Param2);


/** ʥ */
void SyncDrv_SendSignal(C_SYNCDRV *self, int iFactor)
{
	if ( SysCtx_IsIsr() )
	{
		/* ISRθƤӽФʤ顢ƥץͳȯư */
		System_RequestProc(SyncDrv_SendSignalProc, (VPARAM)self, (VPARAM)iFactor);	
	}
	else
	{
		/* Ǥʤľܼ¹ */
		SyncDrv_SendSignalProc((VPARAM)self, (VPARAM)iFactor);
	}
}


/** ʥۿ */
void SyncDrv_SendSignalProc(VPARAM Param1, VPARAM Param2)
{
	C_SYNCDRV	*self;
	C_SYNCFILE	*pFile;
	int			iFactor;
	
	self    = (C_SYNCDRV *)Param1;
	iFactor = (int)Param2;
	
	
	SysMtx_Lock(self->hMtx);	/* ƥ륻 */
	
	/* ե륪֥Ȥ˥ʥ */
	pFile = self->pFileHead;
	if ( pFile != NULL )
	{
		do
		{
			/* ʥ */
			SyncFile_SetSignal(pFile, iFactor);
			
			/* ˿ʤ */
			pFile = pFile->pNext;
		} while ( pFile != self->pFileHead);
	}
	
	SysMtx_Unlock(self->hMtx);	/* ƥ륻Ф */
}


/* end of file */
