/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  syncfile.h
 * @brief %jp{ƱǽդǥХɥ饤дܥ饹}
 *
 * %jp{եǥץȤƵǽ륯饹}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "hosaplfw.h"
#include "syncdrv_local.h"
#include "system/system/system.h"


/** γ */
FILE_ERR SyncDrv_StartProcess(C_SYNCDRV *self, C_SYNCFILE *pSyncFile, int iFuctor)
{
	SysMtx_Lock(self->hMtx);	/* ƥ륻 */
	
	/* ʥ򥯥ꥢ */
	SyncFile_ClearSignal(pSyncFile, iFuctor);
	
	if ( self->ppBusyFile[iFuctor] == NULL )
	{
		/* ïƤʤн */
		self->ppBusyFile[iFuctor] = pSyncFile;
	}
	else
	{
		/* ֥å󥰥⡼ɤ̵ʤȴ */
		if ( SyncFile_GetSyncMode(pSyncFile, iFuctor) != FILE_SYNCMODE_BLOCKING )
		{
			SysMtx_Unlock(self->hMtx);	/* ƥ륻Ф */
			return FILE_ERR_BUSY;
		}
		
		/* ޤԤ */
		SysMtx_Unlock(self->hMtx);	/* ƥ륻Ф */
		for ( ; ; )
		{
			/* ʥԤ */
			SyncFile_WaitSignal(pSyncFile, iFuctor);

			SysMtx_Lock(self->hMtx);	/* ƥ륻 */
			if ( self->ppBusyFile[iFuctor] == NULL )
			{
				/* ïƤʤн */
				self->ppBusyFile[iFuctor] = pSyncFile;
				break;
			}
			SyncFile_ClearSignal(pSyncFile, iFuctor);
			SysMtx_Unlock(self->hMtx);	/* ƥ륻Ф */		
		}
	}
	
	SysMtx_Unlock(self->hMtx);	/* ƥ륻Ф */
	
	return FILE_ERR_OK;
}


/* end of file */
