/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  process.h
 * @brief %jp{ץ֥}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */

#include "process_local.h"



/* ץ */
HANDLE Process_Create(const char *pszCommand, MEMSIZE StackSize, int Priority)
{
	T_PROCESS_CREATE_INF Inf;
	
	/* ǥե */
	if ( StackSize == 0 )
	{
		StackSize = 4096;
	}
	if ( Priority == 0 )
	{
		Priority = PROCESS_PRIORITY_NORMAL;
	}
	
	Inf.pszCommandLine = pszCommand;							/**< ޥɥ饤 */
	Inf.pszCurrentDir  = Process_GetCurrentDir(HANDLE_NULL);	/**< ưǥ쥯ȥ */
	Inf.pfncEntry      = NULL;									/**< ưɥ쥹 */
	Inf.Param          = 0;										/**< 桼ѥ᡼ */
	Inf.StackSize      = StackSize;								/**< å */
	Inf.Priority       = Priority;								/**< ץͥ */
	Inf.hTerminal      = Process_GetTerminal(HANDLE_NULL);		/**< ߥʥ */
	Inf.hConIn         = Process_GetConIn(HANDLE_NULL);			/**< 󥽡 */
	Inf.hConOut        = Process_GetConOut(HANDLE_NULL);		/**< 󥽡 */
	Inf.hStdIn         = Process_GetStdIn(HANDLE_NULL);			/**< ɸ */
	Inf.hStdOut        = Process_GetStdOut(HANDLE_NULL);		/**< ɸ */
	Inf.hStdErr        = Process_GetStdErr(HANDLE_NULL);		/**< ɸ२顼 */
	
	return Process_CreateEx(&Inf);
}
	


/* end of file */
