/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  process.h
 * @brief %jp{ץ֥}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */

#include <string.h>
#include "process_local.h"
#include "system/system/system_local.h"


/** ǥȥ饯 */
void Process_Destructor(C_PROCESS *self)
{
	/* ץ */
	SysPrc_Delete(self->hPrc);
	
	/* Ԥ碌ѥ٥ */
	SysEvt_Delete(self->hEvt);
	
	/* åѥ곫 */
	SysMem_Free(self->pStack);

	/* ޥɥ饤ѥ곫 */
	SysMem_Free(self->pszCommandLine);

	/* ȥǥ쥯ȥѥ곫 */
	SysMem_Free(self->pszCurrentDir);
	
	/* ƥफϿ */
	System_UnregistryProcess(self);
	
	/* Ķѿ */
	if ( self->pEnv != NULL )
	{
		Assoc_Delete(self->pEnv);
	}
	
	/* ƥ饹ǥȥ饯ƤӽФ */
	HandleObj_Destructor(&self->HandleObj);
}


/* end of file */
