/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  system.h
 * @brief %jp{ƥAPI}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include <stdio.h>
#include <string.h>
#include "sysapi_local.h"
#include "kernel.h"


C_SYSMEMHEAP		SysMem_SysMemHeap;			/* ƥ */
C_VALMEMHEAP		SysMem_ValMemHeap;			/* ƥҡץ */

SYSMTX_HANDLE		SysIo_hMtx;					/* I/Oѥҡץѥߥ塼ƥå */
C_VALMEMHEAP		*SysIo_pValMemHeap = NULL;	/* I/Oѥҡץ */

T_SYSPRC_INF		*SysPrc_InfTbl;				/* ץѥơ֥ */
T_SYSINT_INF		*SysInt_InfTbl;				/* INTѥơ֥ */



/* ƥν */
void SysApi_Initialize(void *pMem, MEMSIZE MemSize, MEMSIZE MemAlign, void *pIoMem, MEMSIZE IoMemSize, MEMSIZE IoMemAlign)
{
	/* ν */
	ValMemHeap_Constructor(&SysMem_ValMemHeap, pMem, MemSize, MemAlign);			/* ҡ */
	SysMemHeap_Constructor(&SysMem_SysMemHeap, (C_MEMHEAP *)&SysMem_ValMemHeap);
	
	/* ץơ֥ */
	SysPrc_InfTbl = (T_SYSPRC_INF *)SysMem_Alloc(sizeof(T_SYSPRC_INF) * (_kernel_max_tskid + 1));
	memset(SysPrc_InfTbl, 0, sizeof(T_SYSPRC_INF) * _kernel_max_tskid);

	/* ISRơ֥ */
	SysInt_InfTbl = (T_SYSINT_INF *)SysMem_Alloc(sizeof(T_SYSINT_INF) * (_kernel_max_intno - _kernel_min_intno + 1));
	memset(SysInt_InfTbl, 0, sizeof(T_SYSINT_INF) * (_kernel_max_intno - _kernel_min_intno + 1));
	
	/* I/Oѥ */
	if ( pIoMem != NULL )
	{
		SysIo_hMtx = SysMtx_Create(SYSMTX_ATTR_NORMAL);								/* ¾ѥߥ塼ƥå */	
		SysIo_pValMemHeap = SysMem_Alloc(sizeof(C_VALMEMHEAP));
		ValMemHeap_Constructor(SysIo_pValMemHeap, pIoMem, IoMemSize, IoMemAlign);	/* ҡ */	
	}
}


/* end of file */
