/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  sysmemheap_alloc.c
 * @brief %jp{ƥҡץ饹}%en{system memory heap class}
 *
 * Copyright (C) 2006-2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#ifndef __HOS__sysmemheap_local_h__
#define __HOS__sysmemheap_local_h__


#include "library/container/memheap/memheap_local.h"
#include "system/sysapi/sysapi.h"



/** %jp{SysMemHeap饹}%en{SysMemHeap class} */
typedef struct c_sysmemheap
{
	C_MEMHEAP			MemHeap;		/* Ѿ */
	
	C_MEMHEAP			*pMemHeap;		/* Ѿط */
	SYSMTX_HANDLE		hMtx;
} C_SYSMEMHEAP;


#ifdef __cplusplus
extern "C" {
#endif

void	SysMemHeap_Constructor(C_SYSMEMHEAP *self, C_MEMHEAP *pMemHeap);
void    SysMemHeap_Destructor(C_SYSMEMHEAP *self);

void	*SysMemHeap_Alloc(void *pMemHeap, MEMSIZE Size);					/**< γ */
void	*SysMemHeap_ReAlloc(void *pMemHeap, void *pMem, MEMSIZE Size);		/**< κƳ */
void	SysMemHeap_Free(void *pMemHeap, void *pMem);						/**< γ */
MEMSIZE	SysMemHeap_GetSize(void *pMemHeap, void *pMem);						/**< Υ */
MEMSIZE	SysMemHeap_GetAlign(void *pMemHeap);								/**< ꥢ饤Ȥμ */
MEMSIZE	SysMemHeap_AlignSize(void *pMemHeap, MEMSIZE Size);					/**< 򥢥饤ñ̤˳ĥ */

#ifdef __cplusplus
}
#endif



#endif	/* __HOS__sysmemheap_local_h__ */


/* end of file */
