/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  system.h
 * @brief %jp{ƥAPI}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#ifndef __HOS__system_h__
#define __HOS__system_h__


#include "system/type/type.h"


/* ƥ */
typedef struct t_system_initialize_inf
{
	void	*pSysMemBase;					/**< ƥҡץ˳ƤΰƬɥ쥹 */
	MEMSIZE	SysMemSize;						/**< ƥҡץΥ */
	MEMSIZE	SysMemAlign;					/**< ƥҡץΥ饤ñ */
	
	void	*pIoMemBase;					/**< I/OѤΥҡץΰ */
	MEMSIZE	IoMemSize;						/**< I/OѤΥҡץΰ襵 */
	MEMSIZE	IoMemAlign;						/**< I/OѤΥҡץΥ饤ñ */
	
	MEMSIZE	SystemStackSize;				/**< ƥץ˳Ƥ륹å */
	
	int		(*pfncBoot)(VPARAM Param);		/**< ֡ȥץεư */	
	MEMSIZE	BootStackSize;					/**< ֡ȥץ˳Ƥ륹å */
	VPARAM	BootParam;						/**< ֡ȥץΥѥ᡼ */
} T_SYSTEM_INITIALIZE_INF;


#ifdef __cplusplus
extern "C" {
#endif

void   System_Initialize(const T_SYSTEM_INITIALIZE_INF *pInf);												/**< ƥ */
int    System_RequestProc(void (*pfncProc)(VPARAM Param1, VPARAM Param2), VPARAM Param1, VPARAM Param2);	/**< ƥץؤν */

void   System_Lock(void);
void   System_Unlock(void);

HANDLE System_GetNextProcess(HANDLE hProcess);																/**< Υץ */


void          Whiteboard_SetString(const char *pszKey, const char *pszValue);
const char   *Whiteboard_GetString(const char *pszKey, char *pszBuf, int iBufSize, const char *pszDefault);
void          Whiteboard_SetInteger(const char *pszKey, unsigned long ulValue);
unsigned long Whiteboard_GetInteger(const char *pszKey, unsigned long ulDefault);
const char   *Whiteboard_GetNextKey(const char *pszKey, char *pszBuf, int iBufSize);

#ifdef __cplusplus
}
#endif


#endif	/* __HOS__system_h__ */


/* end of file */
