/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  system.h
 * @brief %jp{ƥAPI}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#ifndef __HOS__system_local_h__
#define __HOS__system_local_h__


#include "system.h"
#include "system/sysapi/sysapi.h"
#include "system/file/file_local.h"
#include "system/process/process_local.h"
#include "library/container/assoc/assoc.h"


#define SYSTEM_PROCQUE_SIZE		64		/* ƥץ׵ᥭ塼󥰿 */



/* ƥץ */
typedef struct t_system_procinf
{
	void		(*pfncProc)(VPARAM Param1, VPARAM Param2);
	VPARAM		Param1;
	VPARAM		Param2;
} T_SYSTEM_PROCINF;


/* ƥ९饹 */
typedef struct c_system
{
	C_PROCESS			Process;		/**< ƥץ */

	C_PROCESS			*pRunProcess;	/**< ¹ץΥꥹ */
		
	HANDLE				hBootProcess;
	
	C_ASSOC				*paWhiteBoard;	/**< ۥ磻ȥܡ */
	
	SYSMTX_HANDLE		hMtxSys;
	SYSPRC_HANDLE		hPrcProc;						
	SYSEVT_HANDLE		hEvtProc;
	volatile int		iProcHead;
	volatile int		iProcTail;
	T_SYSTEM_PROCINF	ProcQue[SYSTEM_PROCQUE_SIZE];
} C_SYSTEM;


extern C_SYSTEM g_System;


#ifdef __cplusplus
extern "C" {
#endif

int    System_Process(VPARAM Param);					/* ƥץ */

HANDLE System_GetSystemProcess(void);
void   System_RegistryProcess(C_PROCESS *pProcess);		/* ץϿ */
void   System_UnregistryProcess(C_PROCESS *pProcess);	/* ץϿ */


#ifdef __cplusplus
}
#endif


#endif	/* __HOS__system_h__ */


/* end of file */
