// ---------------------------------------------------------------------------
//  Hyper Operating System V4 Advance ե졼
//    API饹
//
//                                    Copyright (C) 1998-2009 by Project HOS
//                                    http://sourceforge.jp/projects/hos/
// ---------------------------------------------------------------------------


#include <stdio.h>
#include <stdlib.h>
#include "defercd.h"
#include "apidef.h"
#include "analyze.h"



// 󥹥ȥ饯
CApiDef::CApiDef()
{
	int i;

	m_iDefaultMaxId = 0;
	m_iMaxId        = -1;
	m_iObjs         = 0;
	m_iResObj       = 0;
	for ( i = 0; i < API_MAX_OBJS; i++ )
	{
		m_pParamPacks[i] = NULL;
		m_iId[i]         = 0;
	}
}


// ǥȥ饯
CApiDef::~CApiDef()
{
	int i;

	for ( i = 0; i < API_MAX_OBJS; i++ )
	{
		delete m_pParamPacks[i];
	}
}


// ѥ᡼ɲáĶȴ
int CApiDef::AddParams(const char* pszParams)
{
	char szParamBlock[API_MAX_PARAM];
	char szParam[API_MAX_PARAM];
	int  iErr = 0;
	int  iIndex = 0;
	int  i, j;

	// ѥ᡼Ǽѥ֥
	m_pParamPacks[m_iObjs] = new CParamPack();

	for ( i = 0; i < m_iParams; i++ )
	{
		if ( m_iParamSyntax[i] == 0 )
		{
			// ñȥѥ᡼ڤФ
			iErr = CAnalyze::GetParameter(szParam, pszParams);
			if ( iErr != CFG_ERR_OK )
			{
				break;
			}

			// ѥ᡼ɲ
			CAnalyze::SpaceCut(szParam);
			m_pParamPacks[m_iObjs]->SetParam(iIndex++, szParam);
		}
		else
		{
			// ɤФ
			while ( *pszParams == ' ' )
			{
				pszParams++;
			}

			// ֥åϥå
			if ( *pszParams++ != '{' )
			{
				iErr = CFG_ERR_SYNTAX;
				break;
			}
			
			// ֥åڤФ
			iErr = CAnalyze::SearchChar(szParamBlock, pszParams, '}');
			if ( iErr != CFG_ERR_OK )
			{
				break;
			}

			// ֥åɤ߽Ф
			const char* pszParamBlock = szParamBlock;
			for ( j = 0; j < m_iParamSyntax[i] + 1; j++ )
			{
				// ñȥѥ᡼ڤФ
				iErr = CAnalyze::GetParameter(szParam, pszParamBlock);
				if ( iErr != CFG_ERR_OK )
				{
					break;
				}

				// ѥ᡼ɲ
				CAnalyze::SpaceCut(szParam);
				if ( szParam[0] == '\0')
				{
					break;
				}
				m_pParamPacks[m_iObjs]->SetParam(iIndex++, szParam);
			}
			if ( iErr != CFG_ERR_OK )
			{
				iErr = CFG_ERR_SYNTAX;
				break;
			}
			if ( j != m_iParamSyntax[i] )
			{
				iErr = CFG_ERR_PARAM;
				break;
			}
		}
	}

	if ( iErr == CFG_ERR_OK )
	{
		m_iObjs++;
	}

	return iErr;
}


// ưIDֹ
int CApiDef::AutoId(void)
{
	bool blUsedId[65536];
	int iId;
	int i;
	
	if ( m_iObjs > 0 )
	{
		// ѿ
		for ( i = 0; i < 65536; i++ )
		{
			blUsedId[i] = false;
		}
		
		// ͻID򥵡
		for ( i = 0; i < m_iObjs; i++ )
		{
			iId = atoi(m_pParamPacks[i]->GetParam(0));
			if ( iId > 0 )
			{
				if ( m_iId[i] != 0 )
				{
					return CFG_ERR_ID_CONFLICT;		// ID
				}
				m_iId[i] = iId;
				blUsedId[iId - 1] = true;
				if ( iId > m_iMaxId )
				{
					m_iMaxId = iId;
				}
			}
		}

		// ID ư
		iId = 1;
		for ( i = 0; i < m_iObjs; i++ )
		{
			if ( m_iId[i] == 0 )
			{
				// ѺѤIDΥå
				while ( blUsedId[iId - 1] )
				{
					iId++;
				}
				m_iId[i] = iId++;
			}
		}
		iId--;

		if ( iId > m_iMaxId )
		{
			m_iMaxId = iId;
		}
	}
	
	// IDֹͽ󥪥֥ȿʬ
	if ( m_iResObj > 0 && m_iMaxId < m_iObjs + m_iResObj )
	{
		m_iMaxId = m_iObjs + m_iResObj;
	}
	
	// ̵꤬ϥǥեͤ
	if ( m_iMaxId < 0 )
	{
		m_iMaxId = m_iDefaultMaxId;
	}

	return 0;
}


// ID򥪥ֹ֥Ѵ
int CApiDef::IdToObjNum(int iId)
{
	int i;

	// IDΰפ륪֥Ȥõ
	for ( i = 0; i < m_iObjs; i++ )
	{
		if ( m_iId[i] == iId )
		{
			return i;
		}
	}

	return -1;
}



// ID ե񤭽Ф
void CApiDef::WriteId(FILE* fpId)
{
}


// cfgե񤭽Ф
void CApiDef::WriteCfgDef(FILE* fpCfg)
{
}

// cfgե񤭽Ф
void CApiDef::WriteCfgIni(FILE* fpCfg)
{
}

// cfgե뵯ư񤭽Ф
void CApiDef::WriteCfgStart(FILE* fpCfg)
{
}

// end of file
