// ---------------------------------------------------------------------------
//  Hyper Operating System V4  ե졼                           
//    CRE_MPF API ν                                                      
//                                                                            
//                                    Copyright (C) 1998-2003 by Project HOS  
//                                    http://sourceforge.jp/projects/hos/     
// ---------------------------------------------------------------------------


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "defercd.h"
#include "crempf.h"
#include "analyze.h"
#include "readcfg.h"


#define CREMPF_MPFID		0
#define CREMPF_MPFATR		1
#define CREMPF_BLKCNT		2
#define CREMPF_BLKSZ		3
#define CREMPF_MPF			4



// 󥹥ȥ饯
CApiCreMpf::CApiCreMpf()
{
	// %jp{ǥեȤκID}
	m_iDefaultMaxId = _KERNEL_TMAX_MPFID;
	
	// ѥ᡼ʸ
	m_iParamSyntax[0] = 0;		// ñȥѥ᡼
	m_iParamSyntax[1] = 4;		// 4ѥ᡼Υ֥å
	m_iParams = 2;
}

// ǥȥ饯
CApiCreMpf::~CApiCreMpf()
{
}



// APIβ
int CApiCreMpf::AnalyzeApi(const char* pszApiName, const char* pszParams)
{
	if ( strcmp(pszApiName, "CRE_MPF") == 0 )
	{
		return AddParams(pszParams);
	}
	else if ( strcmp(pszApiName, "KERNEL_MAX_MPFID") == 0 )
	{
		int iId;

		if ( m_iMaxId > 0 )
		{
			return CFG_ERR_MULTIDEF;
		}

		if ( m_iResObj > 0 )
		{
			return CFG_ERR_DEF_CONFLICT;
		}

		if ( (iId = atoi(pszParams)) < 0 )
		{
			return CFG_ERR_PARAM;
		}

		m_iMaxId = iId;

		return CFG_ERR_OK;
	}
	else if ( strcmp(pszApiName, "KERNEL_RSV_MPFID") == 0 )
	{
		int iId;

		if ( m_iMaxId > 0 )
		{
			return CFG_ERR_DEF_CONFLICT;
		}

		if ( (iId = atoi(pszParams)) <= 0 )
		{
			return CFG_ERR_PARAM;
		}

		m_iResObj += iId;

		return CFG_ERR_OK;
	}
	
	return CFG_ERR_NOPROC;
}


// ID ե񤭽Ф
void CApiCreMpf::WriteId(FILE* fp)
{
	if ( m_iMaxId <= 0 )
	{
		return;
	}
}


// cfgե񤭽Ф
void  CApiCreMpf::WriteCfgDef(FILE* fp)
{
	const char* pszParam;
	int         i;

	if ( m_iMaxId <= 0 )
	{
		return;
	}

	// Ƚ
	fputs(
		"\n\n\n"
		"/* ------------------------------------------ */\n"
		"/*   create fixed size memory-pool objects    */\n"
		"/* ------------------------------------------ */\n"
		, fp);
	
	// %jp{סΰ}
	for ( i = 0; i < m_iObjs; i++ )
	{
		pszParam = m_pParamPacks[i]->GetParam(CREMPF_MPF);
		if ( strcmp(pszParam, "NULL") == 0 )
		{
			fprintf(
				fp,
				"static VP _kernel_mpf%d_mpfblk[TSZ_MPF((%s), (%s)) + (sizeof(VP) - 1) / sizeof(VP)];\n",
				m_iId[i],
				m_pParamPacks[i]->GetParam(CREMPF_BLKCNT),
				m_pParamPacks[i]->GetParam(CREMPF_BLKSZ));
		}
	}
	

#if _KERNEL_MPFCB_ALGORITHM == _KERNEL_MPFCB_ALG_BLKARRAY
#if _KERNEL_MPFCB_SPLIT_RO
	// %jp{֥åROMʬΥ}
	{
		// %jp{RAM}
		fprintf(fp, "\n_KERNEL_T_MPFCB _kernel_mpfcb_tbl[%d] =\n\t{\n", m_iMaxId);
		for ( i = 1; i <= m_iMaxId; i++ )
		{
			int iObjNum = IdToObjNum(i);
			if ( iObjNum >= 0 )
			{
				fprintf(fp, "\t\t{");
				WriteMpfcbRam(fp, iObjNum);
				fprintf(fp, "},\n");
			}
			else
			{
				fprintf(fp, "\t\t{{0}, },\n");
			}
		}
		fprintf(fp, "\t};\n");

		// %jp{ROM}
		fprintf(fp, "\nconst _KERNEL_T_MPFCB_RO _kernel_mpfcb_ro_tbl[%d] =\n\t{\n", m_iMaxId);
		for ( i = 1; i <= m_iMaxId; i++ )
		{
			int iObjNum = IdToObjNum(i);
			if ( iObjNum >= 0 )
			{
				fprintf(fp, "\t\t{");
				WriteTcbRom(fp, iObjNum);
				fprintf(fp, "},\n");
			}
			else
			{
				fprintf(fp, "\t\t{0},\n");
			}
		}
		fprintf(fp, "\t};\n\n");
	}
#else
	// ֥åMPFCB
	{
		// %jp{RAM}
		fprintf(fp, "\n_KERNEL_T_MPFCB _kernel_mpfcb_tbl[%d] =\n\t{\n", m_iMaxId);
		for ( i = 1; i <= m_iMaxId; i++ )
		{
			int iObjNum = IdToObjNum(i);
			if ( iObjNum >= 0 )
			{
				fprintf(fp, "\t\t{");
				WriteMpfcbRam(fp, iObjNum);
				WriteMpfcbRom(fp, iObjNum);
				fprintf(fp, "},\n");
			}
			else
			{
				fprintf(fp, "\t\t{{0}, },\n");
			}
		}
		fprintf(fp, "\t};\n");
	}
#endif
#elif _KERNEL_MPFCB_ALGORITHM == _KERNEL_MPFCB_ALG_PTRARRAY
#if _KERNEL_MPFCB_SPLIT_RO
	// ݥROMʬΥ
	{
		fprintf(fp, "\n");
		for ( i = 0; i < m_iObjs; i++ )
		{
			fprintf(fp, "const _KERNEL_T_MPFCB_RO _kernel_tcb_ro_blk_%d = {", m_iId[i]);
			WriteTcbRom(fp, i);
			fprintf(fp, "};\n");
		}
		fprintf(fp, "\n");
		for ( i = 0; i < m_iObjs; i++ )
		{
			fprintf(fp, "_KERNEL_T_MPFCB _kernel_mpfcb_blk_%d = {", m_iId[i]);
			WriteTcbRam(fp, i);
			fprintf(fp, "};\n");
		}
		fprintf(fp, "\n");
		fprintf(fp, "\n_KERNEL_T_MPFCB *_kernel_mpfcb_tbl[%d] =\n\t{\n", m_iMaxId);
		for ( i = 1; i <= m_iMaxId; i++ )
		{
			int iObjNum = IdToObjNum(i);
			if ( iObjNum >= 0 )
			{
				fprintf(fp, "\t\t&_kernel_mpfcb_blk_%d,\n", i);
			}
			else
			{
				fprintf(fp, "\t\tNULL,\n");
			}
		}
		fprintf(fp, "\t};\n");		
	}
#else
	// ݥMPFCB
	{
		fprintf(fp, "\n");
		for ( i = 0; i < m_iObjs; i++ )
		{
			fprintf(fp, "_KERNEL_T_MPFCB _kernel_mpfcb_blk_%d = {", m_iId[i]);
			WriteMpfcbRam(fp, i);
			WriteMpfcbRom(fp, i);
			fprintf(fp, "};\n");
		}
		fprintf(fp, "\n");
		fprintf(fp, "\n_KERNEL_T_MPFCB *_kernel_mpfcb_tbl[%d] =\n\t{\n", m_iMaxId);
		for ( i = 1; i <= m_iMaxId; i++ )
		{
			int iObjNum = IdToObjNum(i);
			if ( iObjNum >= 0 )
			{
				fprintf(fp, "\t\t&_kernel_mpfcb_blk_%d,\n", i);
			}
			else
			{
				fprintf(fp, "\t\tNULL,\n");
			}
		}
		fprintf(fp, "\t};\n");		
	}
#endif
#endif
	
	// %jp{}
	fprintf(
		fp,
		"\nconst ID	_kernel_max_mpfid = %d;\n",
		m_iMaxId);

}


void CApiCreMpf::WriteMpfcbRam(FILE *fp, int iObj)
{
#if _KERNEL_MPFCB_QUE
	fprintf(fp, "{0}, ");		/* %jp{塼} */
#endif

#if _KERNEL_MPFCB_FREBLK
	fprintf(fp, "0, ");			/* %jp{֥å} */
#endif

#if _KERNEL_MPFCB_FBLKCNT
	fprintf(fp, "0, ");			/* %jp{֥å} */
#endif
}


void CApiCreMpf::WriteMpfcbRom(FILE *fp, int iObj)
{
#if _KERNEL_MPFCB_MPFATR
	fprintf(fp, "(%s), ", m_pParamPacks[iObj]->GetParam(CREMPF_MPFATR));		/* %jp{Ĺס°} */
#endif

#if _KERNEL_MPFCB_BLKCNT
	fprintf(fp, "(%s), ", m_pParamPacks[iObj]->GetParam(CREMPF_BLKCNT));		/* %jp{Ǥ֥å(Ŀ)} */
#endif

#if _KERNEL_MPFCB_BLKSZ
	fprintf(fp, "(%s), ", m_pParamPacks[iObj]->GetParam(CREMPF_BLKSZ));			/* %jp{֥åΥ(Хȿ)} */
#endif

#if _KERNEL_MPFCB_MPF
	if ( strcmp(m_pParamPacks[iObj]->GetParam(CREMPF_MPF), "NULL") == 0 )
	{
		fprintf(fp, "_kernel_mpf%d_mpfblk, ", m_iId[iObj]);		/* %jp{ĹסΰƬ} */
	}
	else
	{
		fprintf(fp, "(%s), ", m_pParamPacks[iObj]->GetParam(CREMPF_MPF));		/* %jp{ĹסΰƬ} */
	}
#endif
}


// cfgե񤭽Ф
void  CApiCreMpf::WriteCfgIni(FILE* fp)
{
	if ( m_iMaxId <= 0 )
	{
		return;
	}
}


// cfgե뵯ư񤭽Ф
void  CApiCreMpf::WriteCfgStart(FILE* fp)
{
	if ( m_iMaxId <= 0 )
	{
		return;
	}
}


// ---------------------------------------------------------------------------
//  Copyright (C) 1998-2003 by Project HOS                                    
// ---------------------------------------------------------------------------
