// ---------------------------------------------------------------------------
//  Hyper Operating System V4 Advance ե졼                           
//    KERNEL_DPC_QUE API ν                                                  
//                                                                            
//                                    Copyright (C) 1998-2006 by Project HOS  
//                                    http://sourceforge.jp/projects/hos/     
// ---------------------------------------------------------------------------


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "defercd.h"
#include "dpcque.h"
#include "analyze.h"
#include "readcfg.h"


#define DPCQUE_QUECNT		0
#define DPCQUE_QUE			1


// 󥹥ȥ饯
CApiDpcQue::CApiDpcQue()
{
	// ѥ᡼ʸ
	m_iParamSyntax[0] = 0;		// ñȥѥ᡼
	m_iParams = 2;
}


// ǥȥ饯
CApiDpcQue::~CApiDpcQue()
{
}


// ưIDֹ
int CApiDpcQue::AutoId(void)
{
	return CFG_ERR_OK;
}


// APIβ
int CApiDpcQue::AnalyzeApi(const char* pszApiName, const char* pszParams)
{
	if ( strcmp(pszApiName, "KERNEL_DPC_QUE") == 0 )
	{
		if ( m_iObjs > 0 )
		{
			return CFG_ERR_MULTIDEF;
		}

		return AddParams(pszParams);
	}

	return CFG_ERR_NOPROC;
}


// cfgե񤭽Ф
void  CApiDpcQue::WriteCfgDef(FILE* fp)
{
#if _KERNEL_SPT_DPC
	const char* pszQue;
	const char* pszQueCnt;

	// Ƚ
	fputs(
		"\n\n\n"
		"/* ------------------------------------------ */\n"
		"/*                 DPC queue                  */\n"
		"/* ------------------------------------------ */\n\n"
		, fp);

	// ѥ᡼ɤ߽Ф
	if ( m_iObjs > 0 )
	{
		pszQueCnt = m_pParamPacks[0]->GetParam(DPCQUE_QUECNT);
		pszQue    = m_pParamPacks[0]->GetParam(DPCQUE_QUE);
	}
	else
	{
		pszQueCnt = "32";		// ̵꤬Хǥեȥ
		pszQue    = "NULL";		// ̵꤬NULL(ư)
	}

	if ( strcmp(pszQue, "NULL") == 0 )
	{
		fprintf(
			fp,
			"VP_INT _kernel_dpc_queblk[(%s)];\n\n",
			pszQueCnt);
	}
#endif
}


// cfgե뵯ư񤭽Ф
void  CApiDpcQue::WriteCfgIni(FILE* fp)
{
#if _KERNEL_SPT_DPC
	const char* pszQue;
	const char* pszQueCnt;

	// ѥ᡼ɤ߽Ф
	if ( m_iObjs > 0 )
	{
		pszQueCnt = m_pParamPacks[0]->GetParam(DPCQUE_QUECNT);
		pszQue    = m_pParamPacks[0]->GetParam(DPCQUE_QUE);
	}
	else
	{
		pszQueCnt = "32";		// ̵꤬Хǥեȥ
		pszQue    = "NULL";		// ̵꤬NULL(ư)
	}
	
	if ( strcmp(pszQue, "NULL") == 0 )
	{
		fprintf(
			fp,
			"\t_KERNEL_SYS_INI_DPC((VP)(_kernel_dpc_queblk), (UINT)sizeof(_kernel_dpc_queblk) / sizeof(VP_INT));\n");
	}
	else
	{
		fprintf(
			fp,
			"\t_KERNEL_SYS_INI_DPC((VP)(%s), (UINT)(%s));\n",
			pszQue, pszQueCnt);
	}
#endif
}


// end of file
