// ---------------------------------------------------------------------------
//  Hyper Operating System V4  ե졼                           
//    HOS_INT_STK API ν                                                  
//                                                                            
//                                    Copyright (C) 1998-2010 by Project HOS  
//                                    http://sourceforge.jp/projects/hos/     
// ---------------------------------------------------------------------------


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "defercd.h"
#include "intstk.h"
#include "analyze.h"
#include "readcfg.h"


#define INTSTK_STKSZ		0
#define INTSTK_STK			1


// 󥹥ȥ饯
CApiIntStack::CApiIntStack()
{
	// ѥ᡼ʸ
	m_iParamSyntax[0] = 0;		// ñȥѥ᡼
	m_iParams = 2;

	// åݥ
	m_szStackPointer[0] = '\0';
}


// ǥȥ饯
CApiIntStack::~CApiIntStack()
{
}


// ưIDֹ
int CApiIntStack::AutoId(void)
{
	return CFG_ERR_OK;
}


// APIβ
int CApiIntStack::AnalyzeApi(const char* pszApiName, const char* pszParams)
{
	if ( strcmp(pszApiName, "KERNEL_INT_STK") == 0 )
	{
		if ( m_iObjs > 0 )
		{
			return CFG_ERR_MULTIDEF;
		}

		if ( m_szStackPointer[0] != '\0' )
		{
			return CFG_ERR_DEF_CONFLICT;
		}

		return AddParams(pszParams);
	}

	return CFG_ERR_NOPROC;
}


// cfgե񤭽Ф
void  CApiIntStack::WriteCfgDef(FILE* fp)
{
	const char* pszSize;
	const char* pszStack;

	// ѥ᡼ɤ߽Ф
	if ( m_iObjs <= 0 )
	{
		pszSize  = "256";
		pszStack = "NULL";
	}
	else
	{
		pszSize  = m_pParamPacks[0]->GetParam(INTSTK_STKSZ);
		pszStack = m_pParamPacks[0]->GetParam(INTSTK_STK);
	}


	// Ƚ
	fputs(
		"\n\n\n"
		"/* ------------------------------------------ */\n"
		"/*             interrupt stack                */\n"
		"/* ------------------------------------------ */\n\n"
		, fp);

	if ( strcmp(pszStack, "NULL") == 0 )
	{
		fprintf(
				fp,
				"VP       _kernel_int_stkblk[((%s) + sizeof(VP) - 1) / sizeof(VP)];\n"
				"const VP _kernel_int_isp = &_kernel_int_stkblk[((%s) + sizeof(VP) - 1) / sizeof(VP)];\n",
				pszSize, pszSize);
	}
	else
	{
		fprintf(
				fp,
				"const VP _kernel_int_isp = (VP)((VB *)(%s) + (SIZE)(%s));\n",
				pszStack, pszSize);
	}

}


// cfgե뵯ư񤭽Ф
void CApiIntStack::WriteCfgIni(FILE* fp)
{
	const char* pszSize;
	const char* pszStack;

	// ѥ᡼ɤ߽Ф
	if ( m_iObjs <= 0 )
	{
		pszSize  = "256";
		pszStack = "NULL";
	}
	else
	{
		pszSize  = m_pParamPacks[0]->GetParam(INTSTK_STKSZ);
		pszStack = m_pParamPacks[0]->GetParam(INTSTK_STK);
	}
	
		
	if ( strcmp(pszStack, "NULL") == 0 )
	{
		fprintf(
			fp,
			"\t_KERNEL_SYS_INI_INTSTK((SIZE)sizeof(_kernel_int_stkblk), (VP)(_kernel_int_stkblk));\n");
	}
	else
	{
		fprintf(
			fp,
			"\t_KERNEL_SYS_INI_INTSTK((SIZE)(%s), (VP)(%s));\n",
			pszSize, pszStack);
	}
}



// ---------------------------------------------------------------------------
//  end of file                           
// ---------------------------------------------------------------------------
