# ----------------------------------------------------------------------------
# Hyper Operating System V4 Advance
#  makefile for Panasonic MN103S series
#
# Copyright (C) 1998-2007 by Project HOS
# http://sourceforge.jp/projects/hos/
# ----------------------------------------------------------------------------



# --------------------------------------
#  %jp{Ƽ}{setting}
# --------------------------------------

# %jp{åȥ饤֥̾}%en{target library name}
TARGET ?= libhosv4a


# %jp{ƥ}%en{architecture}
ARCH_NAME ?= mn103s
ARCH_PROC ?= mn103/mn1030
ARCH_IRC  ?= mn103/mn103s
ARCH_CC   ?= cc103


# %jp{ǥ쥯ȥ}
TOP_DIR           = ../../../../..
KERNEL_DIR        = $(TOP_DIR)/kernel
KERNEL_MAKINC_DIR = $(KERNEL_DIR)/build/common/gmake
INC_PROC_DIR      = $(KERNEL_DIR)/include/arch/proc/$(ARCH_PROC)
INC_IRC_DIR       = $(KERNEL_DIR)/include/arch/irc/$(ARCH_IRC)
SRC_PROC_DIR      = $(KERNEL_DIR)/source/arch/proc/$(ARCH_PROC)
SRC_PROC_CC_DIR   = $(KERNEL_DIR)/source/arch/proc/$(ARCH_PROC)/$(ARCH_CC)
SRC_IRC_DIR       = $(KERNEL_DIR)/source/arch/irc/$(ARCH_IRC)
SRC_IRC_CC_DIR    = $(KERNEL_DIR)/source/arch/irc/$(ARCH_IRC)/$(ARCH_CC)
CFGRTR_DIR        = $(TOP_DIR)/cfgrtr/build/gcc


# %jp{ե졼}%en{kernel configurator}
CFGRTR = h4acfg-$(ARCH_NAME)


# %jp{ͥ}%en{kernel flag}
KERNEL = Yes


# %jp{ɹ}%en{common setting}
include $(KERNEL_MAKINC_DIR)/common.inc


# %jp{ѥ}%en{add source directories}
INC_DIRS += $(INC_PROC_DIR) $(INC_IRC_DIR)
SRC_DIRS += $(SRC_PROC_DIR) $(SRC_PROC_DIR) $(SRC_PROC_CC_DIR) $(SRC_IRC_DIR) $(SRC_IRC_CC_DIR)


# %jp{ץե饰}%en{option flags}
AFLAGS  = 
CFLAGS  = 
ARFLAGS = 


# %jp{ѥ¸ɹ}%en{compiler dependent definitions}
include $(KERNEL_MAKINC_DIR)/$(ARCH_CC)_d.inc

# %jp{饤֥ɹ}%en{definitions for library}
include $(KERNEL_MAKINC_DIR)/maklib_d.inc




# --------------------------------------
#  %jp{ե}%en{source files}
# --------------------------------------

# %jp{֥եɲ}%en{assembry sources}
ASRCS += $(SRC_PROC_CC_DIR)/kini_prc.as
ASRCS += $(SRC_PROC_CC_DIR)/kdis_int.as
ASRCS += $(SRC_PROC_CC_DIR)/kena_int.as
ASRCS += $(SRC_PROC_CC_DIR)/kwai_int.as
ASRCS += $(SRC_PROC_CC_DIR)/kcre_ctx.as
ASRCS += $(SRC_PROC_CC_DIR)/krst_ctx.as
ASRCS += $(SRC_PROC_CC_DIR)/ksta_ctx.as
ASRCS += $(SRC_PROC_CC_DIR)/kswi_ctx.as
ASRCS += $(SRC_PROC_CC_DIR)/kint_hdr.as


# %jp{Cեɲ}%en{C sources}
CSRCS += $(SRC_PROC_DIR)/val_int.c
CSRCS += $(SRC_IRC_DIR)/ini_irc.c
CSRCS += $(SRC_IRC_DIR)/exe_irc.c
CSRCS += $(SRC_IRC_DIR)/ena_int.c
CSRCS += $(SRC_IRC_DIR)/dis_int.c
CSRCS += $(SRC_IRC_DIR)/clr_int.c
CSRCS += $(SRC_IRC_DIR)/chg_ilv.c
CSRCS += $(SRC_IRC_DIR)/get_ilv.c


# %jp{ͥ붦̥ɲ}%en{kernel common sources}
include $(KERNEL_MAKINC_DIR)/knlsrc.inc




# --------------------------------------
#  %jp{롼}%en{rules}
# --------------------------------------

# %jp{ALL}%en{all}
.PHONY : all
all: makelib_all
	$(MAKE) -C $(CFGRTR_DIR) -f gmake.mak TARGET=$(CFGRTR) ARCH_PROC=$(ARCH_PROC) ARCH_IRC=$(ARCH_IRC)

# %jp{꡼}%en{clean}
.PHONY : clean
clean: makelib_clean
	$(MAKE) -C $(CFGRTR_DIR) -f gmake.mak TARGET=$(CFGRTR) ARCH_PROC=$(ARCH_PROC) ARCH_IRC=$(ARCH_IRC) clean
	$(RM) -f *.lst

# %jp{¸ط}%en{make depend}
.PHONY : depend
depend: makelib_depend

# %jp{祳ԡ}%en{source files copy}
.PHONY : srccpy
srccpy: makelib_srccpy


# %jp{饤֥ɹ}%en{rules for library}
include $(KERNEL_MAKINC_DIR)/maklib_r.inc

# %jp{ѥ¸Υ롼ɹ}%en{rules for compiler}
include $(KERNEL_MAKINC_DIR)/$(ARCH_CC)_r.inc




# --------------------------------------
#  %jp{¸ط}%en{dependency}
# --------------------------------------

# %jp{ͥ¸طɹ}{dependency list of kernel sources}
include $(KERNEL_MAKINC_DIR)/knldep.inc


$(OBJS_DIR)/val_int.$(EXT_OBJ)	:	$(COMMON_HEADERS)
$(OBJS_DIR)/ini_irc.$(EXT_OBJ)	:	$(COMMON_HEADERS)
$(OBJS_DIR)/exe_irc.$(EXT_OBJ)	:	$(COMMON_HEADERS)
$(OBJS_DIR)/ena_int.$(EXT_OBJ)	:	$(COMMON_HEADERS)
$(OBJS_DIR)/dis_int.$(EXT_OBJ)	:	$(COMMON_HEADERS)
$(OBJS_DIR)/clr_int.$(EXT_OBJ)	:	$(COMMON_HEADERS)
$(OBJS_DIR)/chg_ilv.$(EXT_OBJ)	:	$(COMMON_HEADERS)
$(OBJS_DIR)/get_ilv.$(EXT_OBJ)	:	$(COMMON_HEADERS)



# end of file
