# ----------------------------------------------------------------------------
# Hyper Operating System V4 Advance
#  makefile for win32
#
# Copyright (C) 1998-2006 by Project HOS
# http://sourceforge.jp/projects/hos/
# ----------------------------------------------------------------------------


# %jp{å̾}
TARGET ?= libhosv4a

# %jp{ĥ}
EXT_EXE = exe

# %jp{ƥѥ}
ARCH_PROC ?= win/win32
ARCH_IRC  ?= simple
ARCH_CC   ?= gcc


# %jp{ġ}
GCC_ARCH ?=
CMD_CC   ?= $(GCC_ARCH)gcc
CMD_ASM  ?= $(GCC_ARCH)gcc
CMD_LIBR ?= $(GCC_ARCH)ar


# %jp{ǥ쥯ȥ}
TOP_DIR           = ../../../../..
KERNEL_DIR        = $(TOP_DIR)/kernel
KERNEL_MAKINC_DIR = $(KERNEL_DIR)/build/common/gmake
OBJS_DIR          = objs_$(TARGET)


# %jp{ͥ}
KERNEL = Yes


# %jp{ɹ}
include $(KERNEL_MAKINC_DIR)/common.inc


# %jp{ƥѥ}
INC_PROC_DIR     = $(KERNEL_DIR)/include/arch/proc/$(ARCH_PROC)
INC_IRC_DIR      = $(KERNEL_DIR)/include/arch/irc/$(ARCH_IRC)
SRC_PROC_DIR     = $(KERNEL_DIR)/source/arch/proc/$(ARCH_PROC)
SRC_PROC_ASM_DIR = $(KERNEL_DIR)/source/arch/proc/$(ARCH_PROC)/$(ARCH_CC)
SRC_IRC_DIR      = $(KERNEL_DIR)/source/arch/irc/$(ARCH_IRC)
SRC_IRC_ASM_DIR  = $(KERNEL_DIR)/source/arch/irc/$(ARCH_IRC)/$(ARCH_CC)

# %jp{ѥ}
INC_DIRS += $(INC_PROC_DIR) $(INC_IRC_DIR)
SRC_DIRS += $(SRC_PROC_DIR) $(SRC_PROC_DIR) $(SRC_PROC_ASM_DIR) $(SRC_IRC_DIR) $(SRC_IRC_ASM_DIR)

# %jp{ץե饰}
AFLAGS  = 
CFLAGS  = 
ARFLAGS = 

# %jp{ե졼}
CFGRTR_DIR = $(TOP_DIR)/cfgrtr/build/gcc
CFGRTR     = h4acfg-win32


# %jp{Cեɲ}
CSRCS += $(SRC_PROC_DIR)/kcre_ctx.c
CSRCS += $(SRC_PROC_DIR)/kdis_int.c
CSRCS += $(SRC_PROC_DIR)/kena_int.c
CSRCS += $(SRC_PROC_DIR)/kini_prc.c
CSRCS += $(SRC_PROC_DIR)/krst_ctx.c
CSRCS += $(SRC_PROC_DIR)/ksta_ctx.c
CSRCS += $(SRC_PROC_DIR)/kswi_ctx.c
CSRCS += $(SRC_PROC_DIR)/kwai_int.c
CSRCS += $(SRC_PROC_DIR)/val_int.c
CSRCS += $(SRC_PROC_DIR)/vsig_int.c


# ֥եɲ
ASRCS += 


# ͥ붦̥ɲ
include $(KERNEL_MAKINC_DIR)/knlsrc.inc


# %jp{ALL}
.PHONY : all
all: makelib_all
	$(MAKE) -C $(CFGRTR_DIR) -f gmake.mak TARGET=$(CFGRTR) ARCH_PROC=$(ARCH_PROC) ARCH_IRC=$(ARCH_IRC)

# %jp{꡼}
.PHONY : clean
clean: makelib_clean
	$(MAKE) -C $(CFGRTR_DIR) -f gmake.mak TARGET=$(CFGRTR) ARCH_PROC=$(ARCH_PROC) ARCH_IRC=$(ARCH_IRC) clean
	$(RM) -f *.lst


# %jp{ѥ¸ɹ}
include $(KERNEL_MAKINC_DIR)/$(ARCH_CC)_d.inc


# %jp{饤֥ɹ}
include $(KERNEL_MAKINC_DIR)/makelib.inc


# %jp{ѥ¸롼ɹ}
include $(KERNEL_MAKINC_DIR)/$(ARCH_CC)_r.inc


# %jp{ͥ¸طɹ}
include $(KERNEL_MAKINC_DIR)/knldep.inc


# end of file
