/**
 *  Hyper Operating System V4 Advance configurator
 *
 * @file  parser.cpp
 * @brief %jp{ϤΥ饹}%en{lexical analyzer class}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include <stdio.h>
#include <ctype.h>
#include "parser.h"
#include "error.h"
#include "debug.h"



// APIϾ
#define PARSER_STATE_API_START					2000	// APIõ
#define PARSER_STATE_API_END					2001	// APIνõ
#define PARSER_STATE_API_NAME					2002	// API̾ʬ
#define PARSER_STATE_API_S_PARAM				2003	// ѥ᡼Ԥ
#define PARSER_STATE_API_PARAM					2004	// ѥ᡼
#define PARSER_STATE_API_PARAM_STR				2005	// ѥ᡼ʸɤ߹
#define PARSER_STATE_API_PARAM_STR_ESC			2006	// ѥ᡼ʸɤ߹ǳESC
#define PARSER_STATE_API_PARAM_CHAR				2007	// ѥ᡼ʸɤ߹
#define PARSER_STATE_API_PARAM_CHAR_ESC			2008	// ѥ᡼ʸɤ߹ǳESC
#define PARSER_STATE_API_ERR_0					3000	// 顼ȯ ζʸޤɤФ
#define PARSER_STATE_API_ERR_1					3001	// 顼ȯ API ";" ޤɤФ

// 
bool CParser::Analyze(FILE *fp, const TSourceInfo *pSrcInf)
{
	int  c;

	// %jp{}
	m_fpInput   = fp;
	m_SrcInf    = *pSrcInf;
	m_blPreProc = false;
	m_blNewLine = true;
	m_iApiState = PARSER_STATE_API_START;


	while ( (c = GetChar()) != EOF )
	{
		if ( m_blPreProc )	// ץץåԤν
		{
			AnalyzePreProc();
			continue;
		}

		// ̾APIν
		switch ( m_iApiState )
		{
		case PARSER_STATE_API_START:	// APIõ
			if ( isspace(c) )
			{
				// ʸʤ饹롼
			}
			else if ( isalpha(c) || c == '_' )	// ͭʸʤAPI̾ϤȤߤʤ
			{
				m_strApiName = c;
				m_iApiState = PARSER_STATE_API_NAME;
			}
			else
			{
				ParseError(ERRTYPE_ERROR, ERROR_SYNTAX); // 顼
				m_iApiState = PARSER_STATE_API_ERR_0;
			}
			break;

		case PARSER_STATE_API_NAME:		// API̾ɤ߹
			if ( isalnum(c) || c == '_' )
			{
				m_strApiName += c;
			}
			else if ( c == '(' )		// '(' ʤѥ᡼βϤ˰ܹ
			{
				if ( AnalyzeParam(&m_ApiParam, ')') )
				{
					m_iApiState = PARSER_STATE_API_END;
				}
				else
				{
					m_iApiState = PARSER_STATE_API_ERR_1;
				}
			}
			else if ( isspace(c) )		// ʸʤѥ᡼λϤޤõ
			{
				m_iApiState = PARSER_STATE_API_S_PARAM;
			}
			else
			{
				ParseError(ERRTYPE_ERROR, ERROR_SYNTAX); // 顼
				m_iApiState = PARSER_STATE_API_ERR_0;
			}
			break;

		case PARSER_STATE_API_S_PARAM:
			if ( c == '(' )		// '(' ʤѥ᡼βϤ˰ܹ
			{
				if ( AnalyzeParam(&m_ApiParam, ')') )
				{
					m_iApiState = PARSER_STATE_API_END;
				}
				else
				{
					m_iApiState = PARSER_STATE_API_ERR_1;
				}
			}
			if ( isspace(c) )	// ʸʤõ³
			{
			}
			else
			{
				ParseError(ERRTYPE_ERROR, ERROR_SYNTAX); // 顼
				m_iApiState = PARSER_STATE_API_ERR_0;
			}
			break;

		case PARSER_STATE_API_END:
			if ( c == ';' )
			{
				ApiProc();
				m_iApiState = PARSER_STATE_API_START;
			}
			else if ( isspace(c) )
			{
			}
			else
			{
				ParseError(ERRTYPE_ERROR, ERROR_SYNTAX);	// 顼
				m_iApiState = PARSER_STATE_API_ERR_1;
			}
			break;

		case PARSER_STATE_API_ERR_0:	// ŬʶڤޤɤФƷ³
			if ( c == ';' || isspace(c) )
			{
				m_iApiState = PARSER_STATE_API_START;
			}
			break;

		case PARSER_STATE_API_ERR_1:	// ;ޤɤФƤ³
			if ( c == ';' )
			{
				m_iApiState = PARSER_STATE_API_START;
			}
			break;
		}
	}
	
	// ǤEOFʤ̿顼
	if ( m_iApiState != PARSER_STATE_API_START )
	{
		ParseError(ERRTYPE_FATAL, FATAL_EOF);		// 顼
		return false;
	}
	
	return true;
}



// ץץåԤξ
#define PARSER_STATE_PRE_NORMAL					1000	// ץץåɤ߹
#define PARSER_STATE_PRE_ESC					1001	// ץץåɤ߹ǥʸ

// ץץåԤβ
bool CParser::AnalyzePreProc(void)
{
	int c;

	m_strPre    = '#';
	m_iPreState = PARSER_STATE_PRE_NORMAL;

	while ( (c = GetChar()) != EOF )
	{
		switch ( m_iPreState )
		{
		case PARSER_STATE_PRE_NORMAL:	// ̾
			if ( c == '\n' )		// Ԥ褿餽ޤǤǣԤȤƽ
			{
				PreProc();
				m_strPre    = "";
				m_blPreProc = false;
				return true;
			}
			else if ( c == '\\' )	// ʸ
			{
				m_iPreState = PARSER_STATE_PRE_ESC;
			}
			else	// ʳʤ
			{
				m_strPre += c;	// ̤ɤ߹
			}
			break;

		case PARSER_STATE_PRE_ESC:		// ʸμʸ
			if ( c == '\n' )	// Ԥʤִ
			{
				m_strPre += ' ';
				m_iPreState = PARSER_STATE_PRE_NORMAL;
			}
			else if ( c == '\\' )	// ξϥ³(Τʡ)
			{
				m_strPre += '\\';
			}
			else
			{
				m_strPre += '\\';
				m_strPre += c;
				m_iPreState = PARSER_STATE_PRE_NORMAL;
			}
			break;
		}
	}

	return false;
}



#define PARSER_STATE_PARAM_START			40000
#define PARSER_STATE_PARAM_NORMAL			40001
#define PARSER_STATE_PARAM_STR				40002
#define PARSER_STATE_PARAM_STR_ESC			40003
#define PARSER_STATE_PARAM_CHR				40004
#define PARSER_STATE_PARAM_CHR_ESC			40005

// APIѥ᡼β
bool CParser::AnalyzeParam(CParamBlock *pParam, int cEndChar)
{
	string strParam;
	int iParenNest = 0;
	int iState = PARSER_STATE_PARAM_START;
	int c;

	while ( (c = GetChar()) != EOF )
	{
		if ( m_blPreProc )	// ץץåԤν
		{
			AnalyzePreProc();
			continue;
		}

		switch ( iState )
		{
		case PARSER_STATE_PARAM_START:
			if ( c == '{' )
			{
				AnalyzeParam(pParam->AddParamBlock(), '}');
			}
			else if ( c == ',' || c == cEndChar )
			{
	//			ParseError(ERRTYPE_WARNING, WARNING_PARAM_EMPTY);	// ٹ(ѥ᡼)
				
				pParam->AddString(strParam.c_str());
				if ( c == cEndChar )
				{
					return true;
				}
				strParam = "";
			}
			else if ( isspace(c) )	// ʸʤ
			{
				// Τޤ
			}
			else if ( c == ';' )
			{
				ParseError(ERRTYPE_ERROR, ERROR_SEMICOLON);			// 顼
				UngetChar(c);
				return false;
			}
			else
			{
				UngetChar(c);
				iState = PARSER_STATE_PARAM_NORMAL;
			}
			break;

		case PARSER_STATE_PARAM_NORMAL:
			if ( (c == ',' || c == cEndChar) && iParenNest == 0 )	// ѥ᡼ü
			{
				pParam->AddString(strParam.c_str());
				if ( c == cEndChar )
				{
					return true;
				}
				strParam = "";
				iState =  PARSER_STATE_PARAM_START;
			}
			else if ( c == '\"' )	// ʸλϤޤ
			{
				strParam += c;
				iState = PARSER_STATE_PARAM_STR;
			}
			else if ( c == '\'' )	// ʸλϤޤ
			{
				strParam += c;
				iState = PARSER_STATE_PARAM_CHR;
			}
			else if ( c == '(' )
			{
				strParam += c;
				iParenNest++;
			}
			else if ( c == ')' )
			{
				strParam += c;
				if ( iParenNest <= 0 )
				{
					ParseError(ERRTYPE_ERROR, ERROR_PAREN);		// 顼
					return false;
				}
				iParenNest--;
			}
			else if ( c == ';' )
			{
				ParseError(ERRTYPE_ERROR, ERROR_SEMICOLON);		// 顼
				UngetChar(c);
				return false;
			}
			else
			{
				strParam += c;
			}
			break;

		case PARSER_STATE_PARAM_STR:
			strParam += c;
			if ( c == '\"' )
			{
				iState = PARSER_STATE_PARAM_NORMAL;
			}
			else if ( c == '\\' )
			{
				iState = PARSER_STATE_PARAM_STR_ESC;
			}
			break;

		case PARSER_STATE_PARAM_STR_ESC:
			strParam += c;
			iState = PARSER_STATE_PARAM_STR;
			break;

		case PARSER_STATE_PARAM_CHR:
			strParam += c;
			if ( c == '\'' )
			{
				iState = PARSER_STATE_PARAM_NORMAL;
			}
			else if ( c == '\\' )
			{
				iState = PARSER_STATE_PARAM_CHR_ESC;
			}
			break;

		case PARSER_STATE_PARAM_CHR_ESC:
			strParam += c;
			iState = PARSER_STATE_PARAM_CHR;
			break;
		}
	}

	// 顼
	ParseError(ERRTYPE_FATAL, FATAL_EOF);		//̿顼
	return false;
}


// ץץåԤν
bool CParser::PreProc(void)
{
	// debug
	printf("PRI : %s\n", m_strPre.c_str());
	
	int  iNum;
	int  iLine;
	char szPath[512];
	iNum = sscanf(m_strPre.c_str(), "# %d %s", &iLine, szPath);
	if ( iNum >= 1 )
	{
		m_SrcInf.iLineNum = iLine;
	}
	if ( iNum >= 2 && szPath[0] == '\"' )
	{
		m_SrcInf.strFileName = szPath;
	}

	return true;
}


// APIν
bool CParser::ApiProc(void)
{
	printf("API : %s\n", m_strApiName.c_str());
	CDebug::PrintParam(&m_ApiParam, 0);
	m_ApiParam.Clear();
	return true;
}


// 1ʸɤ
int CParser::GetChar(void)
{
	int c;

	while ( (c = fgetc(m_fpInput)) == '\r' )
		;

	if ( c == '\n' )
	{
		m_SrcInf.iLineNum++;
		m_SrcInf.iColumnNum = 0;
	}
	else
	{
		m_SrcInf.iColumnNum++;
	}

	if ( c == '\n' )		// ʸʤ
	{
		m_blNewLine = true;		// Ƭե饰ON
	}
	else if ( isspace(c) )	// ʸʤ
	{
		// ⤷ʤ
	}
	else if ( c == '#' )	// Ƭ#ץץåȽ
	{
		if ( m_blNewLine )
		{
			m_blPreProc = true;
			m_blNewLine = false;
		}
	}
	else	// ̾ʸʤ
	{
		m_blNewLine = false;	// Ƭե饰ꥢ
	}

	return c;
}


// 1ʸ᤹
void CParser::UngetChar(int c)
{
	ungetc(c, m_fpInput);
	if ( c == '\n' )
	{
		m_SrcInf.iLineNum--;
	}
	else
	{
		m_SrcInf.iColumnNum--;
	}
}



void CParser::ParseError(int iType, int iCode)
{
	printf("err\n");
#if 0
	const char *pszMsg;
	
	pszMsg = GetErrMessage(iType, iCode);
	
	switch ( iType )
	{
	case PARSER_ERRTYPE_WARNING:
		fprintf(stderr, "%s(%d) Warning(%d): %s\n", m_strFileName.c_str(), m_iLineNum, iCode, pszMsg);
		return;
	
	case PARSER_ERRTYPE_ERROR:
		fprintf(stderr, "%s(%d) Error(%d): %s\n", m_strFileName.c_str(), m_iLineNum, iCode, pszMsg);
		return;

	case PARSER_ERRTYPE_FATAL:
		fprintf(stderr, "%s(%d) Fatal(%d): %s\n", m_strFileName.c_str(), m_iLineNum, iCode, pszMsg);
		exit(2);
		return;
	}
#endif
}
