/**
 *  Hyper Operating System V4 Advance configurator
 *
 * @file  parser.h
 * @brief %jp{ϤΥ饹}%en{lexical analyzer class}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef __parser_h__
#define __parser_h__


#include <stdio.h>
#include "param.h"
#include "srcinf.h"



// %jp{ϤΥ饹}%en{lexical analyzer class}
class CParser
{
public:
	bool Analyze(FILE *fp, const TSourceInfo *pSrcInf);

protected:
	int  GetChar(void);			// %jp{ʸɤ߹}
	void UngetChar(int c);		// %jp{ʸ᤹}

	bool AnalyzePreProc(void);								// %jp{ץץåʸβ}
	bool AnalyzeParam(CParamBlock *pBlock, int cEndChar);	// %jp{ѥ᡼ʬ}

	bool PreProc(void);
	bool ApiProc(void);

	void ParseError(int iType, int iCode);


	FILE*       m_fpInput;		// %jp{ϥե}
	TSourceInfo m_SrcInf;		// %jp{ɾ}

	bool		m_blPreProc;	// %jp{ץץåʸե饰}
	bool		m_blNewLine;	// %jp{Ƭե饰}
	int			m_iPreState;	// %jp{ץץåʸ}
	int			m_iApiState;	// %jp{API}

	string      m_strPre;		// %jp{ץץå}
	string      m_strApiName;	// %jp{API̾}
	CParamBlock m_ApiParam;		// %jp{APIΥѥ᡼}
};


#endif	//  __parser_h__


// end of file
