

#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <string>
using namespace std;


// ѥ᡼ʸ(;ʬʸκ)
string RegularizeParam(const char *pszString)
{
	string str;
	bool   blSpace = false;
	int    iLen;
	int    i;

	// ƬζɤФ
	while ( isspace(*pszString) )
	{
		pszString++;
	}

	// Ⱦζ
	iLen = strlen(pszString);
	while ( iLen > 0 && isspace(pszString[iLen - 1]) )
	{
		iLen--;
	}

	// 
	for ( i = 0; i < iLen; i++ )
	{
		if ( blSpace )	// ³ʤ
		{
			if ( !isspace(pszString[i]) )	// ³¤ɤФ
			{
				str += pszString[i];
				blSpace = false;
			}
		}
		else
		{
			if ( isspace(pszString[i]) )
			{
				str += ' ';			// ʸϥ󥰥륹ڡִ
				blSpace = true;
			}
			else
			{
				str += pszString[i];
			}
		}
	}

	return str;
}


// ʸŸ
string AnalyzeConstantString(const char *pszString)
{
	bool   blEsc = false;
	string str;
	int    c;
	
	// ʸ󳫻ϤޤɤФ
	while ( (c = *pszString++) != '\0' )
	{
		if ( c == '\"' )
		{
			break;
		}
	}
	if ( c == '\0' )
	{
		return "";	// 顼
	}
	
	// ʸŸ
	while ( (c = *pszString++) != '\0' )
	{
		if ( blEsc )
		{
			if ( c == 'a' )
			{
				str += '\a';
			}
			else if ( c == 'b' )
			{
				str += '\b';
			}
			else if ( c == 'f' )
			{
				str += '\f';
			}
			else if ( c == 'n' )
			{
				str += '\n';
			}
			else if ( c == 'r' )
			{
				str += '\r';
			}
			else if ( c == 't' )
			{
				str += '\t';
			}
			else if ( c == 'v' )
			{
				str += '\v';
			}
			else if ( c == 'x' )
			{
				char *next;
				c = (char)strtol(pszString, &next, 16);
				pszString = (const char*)next;
				str += c;
			}
			else if ( c == '0' )
			{
				char *next;
				c = (char)strtol(pszString, &next, 8);
				pszString = (const char*)next;
				str += c;
			}
			else
			{
				str += c;
			}
			blEsc = false;
		}
		else
		{
			if ( c == '\"' )
			{
				break;
			}
			else if ( c == '\\' )
			{
				blEsc = true;
			}
			else
			{
				str += c;
			}
		}
	}
	if ( c == '\0' )
	{
		return "";	// 顼
	}

	return str;
}


// ͤȤͭå
bool CheckNumber(const char *pszString)
{
	char *end;
	
	errno = 0;
	strtol(pszString, &end, 0);
	if ( errno != 0 || *end != '\0' )
	{
		return false;
	}

	return true;
}

// ̻ҤȤͭå
bool CheckIdentifier(const char *pszString)
{
	int c;

	// Ƭϱʸ⤷ '_' Ǥʤаȿ
	c = *pszString++;
	if ( !(isalpha(c) || c == '_') )
	{
		return false;
	}

	// ³ϱѿޤ '_' Ǥʤаȿ
	while ( (c = *pszString++) != '\0' )
	{
		if ( !(isalnum(c) || c == '_' ) )
		{
			return false;
		}
	}

	return true;	// OK
}

